# AISCo - Advanced Industrial Services Co Website

A modern, bilingual (English/Arabic) corporate website for AISCo - Precision CNC Factory in Saudi Arabia. Built with Laravel 11+, Filament Admin Panel, and TailwindCSS.

## 🌟 Features

### Frontend
- ✅ Fully bilingual (English/Arabic) with RTL support
- ✅ Modern, responsive design inspired by ftc.com.sa
- ✅ Dynamic pages with CMS capabilities
- ✅ Service catalog with detailed descriptions
- ✅ Industry showcase (9 industries)
- ✅ Project portfolio with filtering
- ✅ Blog/News system with categories and tags
- ✅ Career/Jobs board with application system
- ✅ Contact and Quote request forms
- ✅ Materials catalog (Metals & Plastics)
- ✅ WhatsApp integration
- ✅ SEO optimized

### Admin Panel (Filament)
- ✅ Complete CMS for all content types
- ✅ Lead management (Contact, Quote, Career applications)
- ✅ Menu builder with drag-drop
- ✅ Media library
- ✅ User management with roles/permissions
- ✅ Settings management
- ✅ Dashboard with widgets

## 🛠 Tech Stack

- **Framework:** Laravel 11+
- **PHP Version:** 8.2+
- **Admin Panel:** Filament 3.2
- **Database:** MySQL
- **Frontend:** Blade + TailwindCSS
- **Build Tool:** Vite
- **Packages:**
  - Spatie Media Library
  - Spatie Permissions
  - Spatie Sluggable
  - Spatie Translatable
  - Intervention Image
  - Maatwebsite Excel

## 📦 Installation

### Prerequisites
- PHP 8.2+
- Composer
- Node.js 18+
- MySQL 8.0+

### Steps

1. **Clone the repository**
```bash
git clone <repository-url>
cd aisco-website
```

2. **Install PHP dependencies**
```bash
composer install
```

3. **Install Node dependencies**
```bash
npm install
```

4. **Environment setup**
```bash
cp .env.example .env
php artisan key:generate
```

5. **Configure database in .env**
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=aisco_website
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

6. **Run migrations and seeders**
```bash
php artisan migrate
php artisan db:seed
```

7. **Create storage link**
```bash
php artisan storage:link
```

8. **Build frontend assets**
```bash
npm run build
# Or for development
npm run dev
```

9. **Start the server**
```bash
php artisan serve
```

## 🌐 URLs

- **Frontend:** http://localhost:8000
- **Admin Panel:** http://localhost:8000/admin

## 📁 Project Structure

```
aisco-website/
├── app/
│   ├── Http/
│   │   ├── Controllers/Frontend/   # 8 controllers
│   │   ├── Middleware/             # SetLocale middleware
│   │   └── Requests/               # Form validation
│   ├── Models/                     # 18 Eloquent models
│   └── Filament/                   # Admin panel resources
├── database/
│   ├── migrations/                 # 11 migration files
│   └── seeders/                    # Demo data seeders
├── lang/
│   ├── en/messages.php            # English translations
│   └── ar/messages.php            # Arabic translations
├── resources/
│   ├── css/app.css                # TailwindCSS styles
│   ├── js/app.js                  # JavaScript
│   └── views/frontend/            # Blade templates
│       ├── layouts/app.blade.php
│       ├── partials/              # Header, Footer
│       └── pages/                 # All page views
├── routes/web.php                 # Frontend routes
├── tailwind.config.js
├── vite.config.js
└── composer.json
```

## 🗄️ Database Schema

### Main Tables
- `users` - Admin users with roles
- `settings` - Key-value site configuration
- `menus` & `menu_items` - Dynamic navigation
- `pages` & `page_sections` - CMS pages
- `services` & `service_sections` & `service_faqs`
- `industries` - 9 industries from PDF
- `projects` & `project_categories` & `project_images`
- `posts` & `post_categories` & `tags`
- `testimonials` & `partners` & `team_members`
- `leads` & `jobs` & `job_applications`
- `material_categories` & `materials`

## 🔧 Configuration

### Locale Middleware
Add to `bootstrap/app.php`:
```php
->withMiddleware(function (Middleware $middleware) {
    $middleware->web(append: [
        \App\Http\Middleware\SetLocale::class,
    ]);
})
```

### Language Switching
The language can be switched via:
- URL: `/language/en` or `/language/ar`
- Stored in session

## 📝 Content from Company Profile

### Services
1. CNC Manufacturing (Subtractive + Additive)
2. Pattern Making
3. Reverse Engineering
4. Polytechnic Education

### Industries Served
1. Aircrafts
2. Military
3. Aerospace
4. Medical Devices
5. Optical Equipment
6. Pattern Making
7. Pharmaceuticals
8. General Spare Parts
9. Oil & Gas

### Materials
**Metals:** Titanium, Tungsten, VIM VAR, Waspaloy, Nickel 200, Rhenium, Stainless Steel, Stavax, Bronze, Carbon Steel, Copper, Hardened Steel, Kovar, Maraging Steel, Molybdenum, Monel, Aluminum, Alloy Steel, Brass

**Plastics:** POM/Delrin/Acetal, ABS, Nylon/PA, PEEK, PTFE/Teflon, PVC, PMMA/Acrylic, PEI/Ultem, HDPE, Polypropylene, Nylatron, UHMW

### Value Proposition
- 69% cost savings vs international sourcing
- 4-week delivery vs 6-9 months
- Example: Helicopter parts $28,600 vs $92,700

## 🎨 Design System

### Colors
- Primary: Blue (#2563eb)
- Secondary: Slate (#0f172a)
- Success: Green (#16a34a)
- Accent: Cyan (#0891b2)

### Typography
- English: Inter, Space Grotesk
- Arabic: Tajawal

### Components
- `.btn-primary` - Primary button
- `.btn-secondary` - Secondary button
- `.btn-outline` - Outline button
- `.nav-link` - Navigation links
- `.card` - Card component

## 🔒 Security Features

- CSRF protection on all forms
- Honeypot anti-spam fields
- Form validation with Laravel Form Requests
- XSS prevention
- SQL injection protection via Eloquent

## 📧 Contact Information

- **Phone:** +966 505 622 994
- **Office:** +966 12 261 4100
- **Email:** info@aiscksa.com
- **Sales:** hummam@aiscksa.com
- **Location:** Jeddah, Saudi Arabia

## 📄 License

Proprietary - All Rights Reserved

## 🤝 Support

For technical support, contact the development team.

---

Built with ❤️ for AISCo - Igniting sparks to start real manufacturing in KSA
