<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Http\Requests\JobApplicationRequest;
use App\Models\Job;
use App\Models\JobApplication;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class CareerController extends Controller
{
    public function index(): View
    {
        $jobs = Job::active()
            ->orderBy('order')
            ->get()
            ->groupBy('department');

        return view('frontend.pages.careers.index', compact('jobs'));
    }

    public function show(string $slug): View
    {
        $job = Job::where('slug', $slug)
            ->active()
            ->firstOrFail();

        $relatedJobs = Job::active()
            ->where('id', '!=', $job->id)
            ->where('department', $job->department)
            ->limit(3)
            ->get();

        return view('frontend.pages.careers.show', compact('job', 'relatedJobs'));
    }

    public function apply(JobApplicationRequest $request, string $slug): RedirectResponse
    {
        $job = Job::where('slug', $slug)->active()->firstOrFail();

        $application = new JobApplication([
            'job_id' => $job->id,
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'cover_letter' => $request->cover_letter,
        ]);

        // Handle CV upload
        if ($request->hasFile('cv')) {
            $path = $request->file('cv')->store('cv-uploads', 'public');
            $application->cv_file = $path;
        }

        $application->save();

        return back()->with('success', __('Your application has been submitted successfully. We will review it and get back to you.'));
    }
}
