<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Industry;
use App\Models\Partner;
use App\Models\Project;
use App\Models\Service;
use App\Models\Testimonial;
use Illuminate\View\View;

class HomeController extends Controller
{
    public function index(): View
    {
        $services = Service::published()
            ->featured()
            ->orderBy('order')
            ->limit(6)
            ->get();

        $industries = Industry::published()
            ->orderBy('order')
            ->limit(9)
            ->get();

        $projects = Project::published()
            ->featured()
            ->with(['category', 'industry'])
            ->orderBy('order')
            ->limit(6)
            ->get();

        $testimonials = Testimonial::active()
            ->featured()
            ->orderBy('order')
            ->limit(6)
            ->get();

        $partners = Partner::active()
            ->orderBy('order')
            ->limit(12)
            ->get();

        return view('frontend.pages.home', compact(
            'services',
            'industries',
            'projects',
            'testimonials',
            'partners'
        ));
    }
}
