<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Industry;
use Illuminate\View\View;

class IndustryController extends Controller
{
    public function index(): View
    {
        $industries = Industry::published()
            ->orderBy('order')
            ->get();

        return view('frontend.pages.industries.index', compact('industries'));
    }

    public function show(string $slug): View
    {
        $industry = Industry::with('projects')
            ->where('slug', $slug)
            ->published()
            ->firstOrFail();

        $relatedProjects = $industry->projects()
            ->published()
            ->limit(6)
            ->get();

        return view('frontend.pages.industries.show', compact('industry', 'relatedProjects'));
    }
}
