<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Illuminate\View\View;

class PageController extends Controller
{
    public function show(string $slug): View
    {
        $page = Page::with('activeSections')
            ->where('slug', $slug)
            ->published()
            ->firstOrFail();

        return view('frontend.pages.dynamic', compact('page'));
    }

    public function about(): View
    {
        $page = Page::with('activeSections')
            ->where('slug', 'about')
            ->published()
            ->first();

        return view('frontend.pages.about', compact('page'));
    }
}
