<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Project;
use App\Models\ProjectCategory;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ProjectController extends Controller
{
    public function index(Request $request): View
    {
        $categories = ProjectCategory::active()
            ->withCount('projects')
            ->orderBy('order')
            ->get();

        $query = Project::published()
            ->with(['category', 'industry', 'images'])
            ->orderBy('order');

        if ($request->filled('category')) {
            $query->whereHas('category', function ($q) use ($request) {
                $q->where('slug', $request->category);
            });
        }

        if ($request->filled('industry')) {
            $query->whereHas('industry', function ($q) use ($request) {
                $q->where('slug', $request->industry);
            });
        }

        $projects = $query->paginate(12);

        return view('frontend.pages.projects.index', compact('projects', 'categories'));
    }

    public function show(string $slug): View
    {
        $project = Project::with(['category', 'industry', 'images'])
            ->where('slug', $slug)
            ->published()
            ->firstOrFail();

        $relatedProjects = Project::published()
            ->where('id', '!=', $project->id)
            ->when($project->category_id, function ($q) use ($project) {
                $q->where('category_id', $project->category_id);
            })
            ->limit(3)
            ->get();

        return view('frontend.pages.projects.show', compact('project', 'relatedProjects'));
    }
}
