<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\View\View;

class ServiceController extends Controller
{
    public function index(): View
    {
        $services = Service::published()
            ->orderBy('order')
            ->get();

        return view('frontend.pages.services.index', compact('services'));
    }

    public function show(string $slug): View
    {
        $service = Service::with(['sections', 'activeFaqs'])
            ->where('slug', $slug)
            ->published()
            ->firstOrFail();

        $relatedServices = Service::published()
            ->where('id', '!=', $service->id)
            ->limit(3)
            ->get();

        return view('frontend.pages.services.show', compact('service', 'relatedServices'));
    }
}
