<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Supported locales
     */
    protected array $supportedLocales = ['en', 'ar'];

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check for locale in session
        $locale = Session::get('locale');
        
        // If not in session, check browser preference
        if (!$locale) {
            $browserLocale = $request->getPreferredLanguage($this->supportedLocales);
            $locale = $browserLocale ?: config('app.locale', 'en');
        }
        
        // Ensure locale is supported
        if (!in_array($locale, $this->supportedLocales)) {
            $locale = config('app.locale', 'en');
        }
        
        // Set the application locale
        App::setLocale($locale);
        
        return $next($request);
    }
}
