<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class Industry extends Model
{
    use HasSlug;

    protected $fillable = [
        'name',
        'name_ar',
        'slug',
        'excerpt',
        'excerpt_ar',
        'description',
        'description_ar',
        'icon',
        'featured_image',
        'banner_image',
        'capabilities',
        'capabilities_ar',
        'materials',
        'meta_title',
        'meta_description',
        'is_featured',
        'is_published',
        'order',
    ];

    protected $casts = [
        'capabilities' => 'array',
        'capabilities_ar' => 'array',
        'materials' => 'array',
        'is_featured' => 'boolean',
        'is_published' => 'boolean',
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    public function projects(): HasMany
    {
        return $this->hasMany(Project::class);
    }

    public function scopePublished($query)
    {
        return $query->where('is_published', true);
    }

    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true);
    }

    public function getLocalizedName(): string
    {
        return app()->getLocale() === 'ar' && $this->name_ar ? $this->name_ar : $this->name;
    }

    public function getLocalizedExcerpt(): ?string
    {
        return app()->getLocale() === 'ar' && $this->excerpt_ar ? $this->excerpt_ar : $this->excerpt;
    }

    public function getLocalizedDescription(): ?string
    {
        return app()->getLocale() === 'ar' && $this->description_ar ? $this->description_ar : $this->description;
    }

    public function getLocalizedCapabilities(): array
    {
        return app()->getLocale() === 'ar' && $this->capabilities_ar ? $this->capabilities_ar : ($this->capabilities ?? []);
    }
}
