<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PageSection extends Model
{
    protected $fillable = [
        'page_id',
        'type',
        'title',
        'title_ar',
        'subtitle',
        'subtitle_ar',
        'content',
        'content_ar',
        'settings',
        'items',
        'background_image',
        'background_color',
        'order',
        'is_active',
    ];

    protected $casts = [
        'settings' => 'array',
        'items' => 'array',
        'is_active' => 'boolean',
    ];

    public const TYPES = [
        'hero' => 'Hero Section',
        'text' => 'Text Block',
        'image_text' => 'Image + Text',
        'stats' => 'Statistics Counter',
        'services_grid' => 'Services Grid',
        'industry_grid' => 'Industries Grid',
        'gallery' => 'Image Gallery',
        'faq' => 'FAQ Accordion',
        'cta' => 'Call to Action',
        'testimonials' => 'Testimonials',
        'partners' => 'Partners/Clients',
        'team' => 'Team Members',
        'projects' => 'Projects Grid',
        'contact_form' => 'Contact Form',
        'quote_form' => 'Quote Request Form',
        'materials' => 'Materials List',
        'video' => 'Video Section',
        'timeline' => 'Timeline',
        'features' => 'Features List',
    ];

    public function page(): BelongsTo
    {
        return $this->belongsTo(Page::class);
    }

    public function getLocalizedTitle(): ?string
    {
        return app()->getLocale() === 'ar' && $this->title_ar ? $this->title_ar : $this->title;
    }

    public function getLocalizedSubtitle(): ?string
    {
        return app()->getLocale() === 'ar' && $this->subtitle_ar ? $this->subtitle_ar : $this->subtitle;
    }

    public function getLocalizedContent(): ?string
    {
        return app()->getLocale() === 'ar' && $this->content_ar ? $this->content_ar : $this->content;
    }

    public function getSetting(string $key, $default = null)
    {
        return data_get($this->settings, $key, $default);
    }

    public function getTypeLabelAttribute(): string
    {
        return self::TYPES[$this->type] ?? $this->type;
    }
}
