<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProjectImage extends Model
{
    protected $fillable = [
        'project_id',
        'image',
        'caption',
        'caption_ar',
        'order',
    ];

    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function getLocalizedCaption(): ?string
    {
        return app()->getLocale() === 'ar' && $this->caption_ar ? $this->caption_ar : $this->caption;
    }
}
