<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ServiceFaq extends Model
{
    protected $fillable = [
        'service_id',
        'question',
        'question_ar',
        'answer',
        'answer_ar',
        'order',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    public function getLocalizedQuestion(): string
    {
        return app()->getLocale() === 'ar' && $this->question_ar ? $this->question_ar : $this->question;
    }

    public function getLocalizedAnswer(): string
    {
        return app()->getLocale() === 'ar' && $this->answer_ar ? $this->answer_ar : $this->answer;
    }
}
