<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TeamMember extends Model
{
    protected $fillable = [
        'name',
        'name_ar',
        'position',
        'position_ar',
        'department',
        'bio',
        'bio_ar',
        'image',
        'email',
        'phone',
        'social_links',
        'is_active',
        'order',
    ];

    protected $casts = [
        'social_links' => 'array',
        'is_active' => 'boolean',
    ];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function getLocalizedName(): string
    {
        return app()->getLocale() === 'ar' && $this->name_ar ? $this->name_ar : $this->name;
    }

    public function getLocalizedPosition(): string
    {
        return app()->getLocale() === 'ar' && $this->position_ar ? $this->position_ar : $this->position;
    }

    public function getLocalizedBio(): ?string
    {
        return app()->getLocale() === 'ar' && $this->bio_ar ? $this->bio_ar : $this->bio;
    }
}
