<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Testimonial extends Model
{
    protected $fillable = [
        'client_name',
        'client_name_ar',
        'client_position',
        'client_position_ar',
        'client_company',
        'client_image',
        'content',
        'content_ar',
        'rating',
        'is_featured',
        'is_active',
        'order',
    ];

    protected $casts = [
        'is_featured' => 'boolean',
        'is_active' => 'boolean',
    ];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true);
    }

    public function getLocalizedClientName(): string
    {
        return app()->getLocale() === 'ar' && $this->client_name_ar ? $this->client_name_ar : $this->client_name;
    }

    public function getLocalizedClientPosition(): ?string
    {
        return app()->getLocale() === 'ar' && $this->client_position_ar ? $this->client_position_ar : $this->client_position;
    }

    public function getLocalizedContent(): string
    {
        return app()->getLocale() === 'ar' && $this->content_ar ? $this->content_ar : $this->content;
    }
}
