<?php

namespace Database\Seeders;

use App\Models\Industry;
use Illuminate\Database\Seeder;

class IndustrySeeder extends Seeder
{
    public function run(): void
    {
        $industries = [
            [
                'name' => ['en' => 'Aircrafts', 'ar' => 'الطائرات'],
                'slug' => 'aircrafts',
                'description' => [
                    'en' => 'Superior machined components for aircraft and jet applications with exacting tolerances. We manufacture precision parts for commercial and private aircraft, including structural components, engine parts, and avionics housings.',
                    'ar' => 'مكونات متفوقة للطائرات وتطبيقات الطائرات النفاثة بتفاوتات دقيقة. نصنع قطعاً دقيقة للطائرات التجارية والخاصة، بما في ذلك المكونات الهيكلية وقطع المحرك وأغلفة إلكترونيات الطيران.'
                ],
                'icon' => 'airplane',
                'is_featured' => true,
                'sort_order' => 1
            ],
            [
                'name' => ['en' => 'Military', 'ar' => 'العسكرية'],
                'slug' => 'military',
                'description' => [
                    'en' => 'Precision parts manufactured for military applications with highest quality materials. Our military-grade components meet stringent defense specifications and are designed for reliability in demanding conditions.',
                    'ar' => 'قطع دقيقة مصنعة للتطبيقات العسكرية بأعلى جودة للمواد. تلبي مكوناتنا العسكرية مواصفات الدفاع الصارمة ومصممة للموثوقية في الظروف الصعبة.'
                ],
                'icon' => 'shield',
                'is_featured' => true,
                'sort_order' => 2
            ],
            [
                'name' => ['en' => 'Aerospace', 'ar' => 'الفضاء'],
                'slug' => 'aerospace',
                'description' => [
                    'en' => 'Aerospace components manufactured with superior machining processes and incredible accuracy. We produce parts for satellites, rockets, and space exploration equipment with the precision demanded by the industry.',
                    'ar' => 'مكونات فضائية مصنعة بعمليات تصنيع متفوقة ودقة مذهلة. ننتج قطعاً للأقمار الصناعية والصواريخ ومعدات استكشاف الفضاء بالدقة التي تتطلبها الصناعة.'
                ],
                'icon' => 'rocket',
                'is_featured' => true,
                'sort_order' => 3
            ],
            [
                'name' => ['en' => 'Medical Devices', 'ar' => 'الأجهزة الطبية'],
                'slug' => 'medical-devices',
                'description' => [
                    'en' => 'Ultra precision machine work for the medical industry including surgical instruments, implants, and diagnostic equipment. Our medical components meet ISO 13485 quality standards.',
                    'ar' => 'أعمال تصنيع فائقة الدقة للصناعة الطبية بما في ذلك الأدوات الجراحية والزرعات ومعدات التشخيص. تلبي مكوناتنا الطبية معايير جودة ISO 13485.'
                ],
                'icon' => 'heart',
                'is_featured' => true,
                'sort_order' => 4
            ],
            [
                'name' => ['en' => 'Optical Equipment', 'ar' => 'المعدات البصرية'],
                'slug' => 'optical-equipment',
                'description' => [
                    'en' => 'CNC machining services benefiting the optical industry with highest precision and accuracy. We manufacture lens housings, precision mounts, and optical instrument components.',
                    'ar' => 'خدمات تصنيع CNC للصناعة البصرية بأعلى دقة. نصنع أغلفة العدسات والحوامل الدقيقة ومكونات الأجهزة البصرية.'
                ],
                'icon' => 'eye',
                'is_featured' => false,
                'sort_order' => 5
            ],
            [
                'name' => ['en' => 'Pattern Making', 'ar' => 'صناعة القوالب'],
                'slug' => 'pattern-making',
                'description' => [
                    'en' => 'Sand casting foundry with advanced patternmaking capabilities. We provide precision patterns for foundry applications using CNC machining, 3D printing, and traditional craftsmanship.',
                    'ar' => 'مسبك صب رملي مع قدرات متقدمة في صناعة القوالب. نقدم قوالب دقيقة لتطبيقات المسابك باستخدام تصنيع CNC والطباعة ثلاثية الأبعاد والحرفية التقليدية.'
                ],
                'icon' => 'template',
                'is_featured' => false,
                'sort_order' => 6
            ],
            [
                'name' => ['en' => 'Pharmaceuticals', 'ar' => 'الأدوية'],
                'slug' => 'pharmaceuticals',
                'description' => [
                    'en' => 'Achieve the impossible with the best CNC machines in the industry for pharmaceutical equipment. We manufacture precision components for drug production, packaging, and quality control equipment.',
                    'ar' => 'حقق المستحيل مع أفضل آلات CNC في الصناعة للمعدات الصيدلانية. نصنع مكونات دقيقة لإنتاج الأدوية والتعبئة ومعدات مراقبة الجودة.'
                ],
                'icon' => 'beaker',
                'is_featured' => false,
                'sort_order' => 7
            ],
            [
                'name' => ['en' => 'General Spare Parts', 'ar' => 'قطع الغيار العامة'],
                'slug' => 'general-spare-parts',
                'description' => [
                    'en' => 'Rapid prototyping and mass production service for automotive and general spare parts. We provide quick turnaround on replacement parts and custom components for industrial machinery.',
                    'ar' => 'خدمة النماذج الأولية السريعة والإنتاج الضخم لقطع غيار السيارات والقطع العامة. نقدم تسليماً سريعاً لقطع الغيار والمكونات المخصصة للآلات الصناعية.'
                ],
                'icon' => 'cog',
                'is_featured' => false,
                'sort_order' => 8
            ],
            [
                'name' => ['en' => 'Oil & Gas', 'ar' => 'النفط والغاز'],
                'slug' => 'oil-gas',
                'description' => [
                    'en' => 'Solutions to the complex component challenges of the oil industry with ultra-precision components. We manufacture downhole tools, valve components, and drilling equipment parts built to withstand extreme conditions.',
                    'ar' => 'حلول لتحديات المكونات المعقدة في صناعة النفط مع مكونات فائقة الدقة. نصنع أدوات الحفر والصمامات ومعدات الحفر المصممة لتحمل الظروف القاسية.'
                ],
                'icon' => 'fire',
                'is_featured' => true,
                'sort_order' => 9
            ]
        ];

        foreach ($industries as $industryData) {
            Industry::create($industryData);
        }
    }
}
