<?php

namespace Database\Seeders;

use App\Models\MaterialCategory;
use App\Models\Material;
use Illuminate\Database\Seeder;

class MaterialSeeder extends Seeder
{
    public function run(): void
    {
        // Create Metal Category
        $metalCategory = MaterialCategory::create([
            'name' => ['en' => 'Metals', 'ar' => 'المعادن'],
            'slug' => 'metals',
            'description' => [
                'en' => 'High-quality metals for precision CNC machining applications.',
                'ar' => 'معادن عالية الجودة لتطبيقات التصنيع الدقيق بالتحكم الرقمي.'
            ],
            'sort_order' => 1
        ]);

        // Create Plastic Category
        $plasticCategory = MaterialCategory::create([
            'name' => ['en' => 'Plastics', 'ar' => 'البلاستيك'],
            'slug' => 'plastics',
            'description' => [
                'en' => 'Engineering plastics for specialized CNC machining requirements.',
                'ar' => 'بلاستيك هندسي لمتطلبات التصنيع المتخصصة بالتحكم الرقمي.'
            ],
            'sort_order' => 2
        ]);

        // Metals from PDF
        $metals = [
            ['name' => ['en' => 'Titanium', 'ar' => 'التيتانيوم'], 'slug' => 'titanium', 'description' => ['en' => 'High strength-to-weight ratio, excellent corrosion resistance. Used in aerospace and medical applications.', 'ar' => 'نسبة قوة إلى وزن عالية، مقاومة ممتازة للتآكل. يستخدم في تطبيقات الطيران والطب.']],
            ['name' => ['en' => 'Tungsten', 'ar' => 'التنجستن'], 'slug' => 'tungsten', 'description' => ['en' => 'Extremely hard and dense, highest melting point of all metals. Used in high-temperature applications.', 'ar' => 'صلب وكثيف للغاية، أعلى نقطة انصهار بين جميع المعادن. يستخدم في تطبيقات درجات الحرارة العالية.']],
            ['name' => ['en' => 'VIM VAR', 'ar' => 'VIM VAR'], 'slug' => 'vim-var', 'description' => ['en' => 'Vacuum Induction Melted, Vacuum Arc Remelted alloys for critical aerospace applications.', 'ar' => 'سبائك مصهورة بالتحريض الفراغي ومعاد صهرها بالقوس الفراغي لتطبيقات الطيران الحرجة.']],
            ['name' => ['en' => 'Waspaloy', 'ar' => 'واسبالوي'], 'slug' => 'waspaloy', 'description' => ['en' => 'Nickel-based superalloy with excellent high-temperature strength.', 'ar' => 'سبيكة فائقة قائمة على النيكل مع قوة ممتازة في درجات الحرارة العالية.']],
            ['name' => ['en' => 'Nickel 200', 'ar' => 'نيكل 200'], 'slug' => 'nickel-200', 'description' => ['en' => 'Commercially pure nickel with excellent corrosion resistance.', 'ar' => 'نيكل نقي تجارياً مع مقاومة ممتازة للتآكل.']],
            ['name' => ['en' => 'Rhenium', 'ar' => 'الرينيوم'], 'slug' => 'rhenium', 'description' => ['en' => 'Rare metal with excellent high-temperature properties.', 'ar' => 'معدن نادر مع خصائص ممتازة في درجات الحرارة العالية.']],
            ['name' => ['en' => 'Stainless Steel', 'ar' => 'الفولاذ المقاوم للصدأ'], 'slug' => 'stainless-steel', 'description' => ['en' => 'Corrosion-resistant steel alloy, available in various grades (303, 304, 316, 17-4 PH, etc.).', 'ar' => 'سبيكة فولاذية مقاومة للتآكل، متوفرة بدرجات مختلفة.']],
            ['name' => ['en' => 'Stavax', 'ar' => 'ستافاكس'], 'slug' => 'stavax', 'description' => ['en' => 'Premium stainless tool steel for mold making and precision components.', 'ar' => 'فولاذ أدوات مقاوم للصدأ ممتاز لصنع القوالب والمكونات الدقيقة.']],
            ['name' => ['en' => 'Bronze', 'ar' => 'البرونز'], 'slug' => 'bronze', 'description' => ['en' => 'Copper-tin alloy with excellent wear resistance and low friction.', 'ar' => 'سبيكة نحاس-قصدير مع مقاومة ممتازة للتآكل واحتكاك منخفض.']],
            ['name' => ['en' => 'Carbon Steel', 'ar' => 'الفولاذ الكربوني'], 'slug' => 'carbon-steel', 'description' => ['en' => 'Steel with carbon as the main alloying element, various grades available.', 'ar' => 'فولاذ مع الكربون كعنصر السبيكة الرئيسي، درجات مختلفة متوفرة.']],
            ['name' => ['en' => 'Copper', 'ar' => 'النحاس'], 'slug' => 'copper', 'description' => ['en' => 'Excellent electrical and thermal conductivity.', 'ar' => 'موصلية كهربائية وحرارية ممتازة.']],
            ['name' => ['en' => 'Hardened Steel', 'ar' => 'الفولاذ المقسى'], 'slug' => 'hardened-steel', 'description' => ['en' => 'Heat-treated steel for high hardness and wear resistance.', 'ar' => 'فولاذ معالج حرارياً للصلابة العالية ومقاومة التآكل.']],
            ['name' => ['en' => 'Kovar', 'ar' => 'كوفار'], 'slug' => 'kovar', 'description' => ['en' => 'Iron-nickel-cobalt alloy with controlled thermal expansion.', 'ar' => 'سبيكة حديد-نيكل-كوبالت مع تمدد حراري متحكم فيه.']],
            ['name' => ['en' => 'Maraging Steel', 'ar' => 'فولاذ ماراجينج'], 'slug' => 'maraging-steel', 'description' => ['en' => 'Ultra-high strength steel used in aerospace and tooling.', 'ar' => 'فولاذ فائق القوة يستخدم في الطيران والأدوات.']],
            ['name' => ['en' => 'Molybdenum', 'ar' => 'الموليبدينوم'], 'slug' => 'molybdenum', 'description' => ['en' => 'Refractory metal with high melting point and strength.', 'ar' => 'معدن حراري مع نقطة انصهار وقوة عالية.']],
            ['name' => ['en' => 'Monel', 'ar' => 'مونيل'], 'slug' => 'monel', 'description' => ['en' => 'Nickel-copper alloy with excellent corrosion resistance.', 'ar' => 'سبيكة نيكل-نحاس مع مقاومة ممتازة للتآكل.']],
            ['name' => ['en' => 'Aluminum', 'ar' => 'الألومنيوم'], 'slug' => 'aluminum', 'description' => ['en' => 'Lightweight, corrosion-resistant, various alloys (6061, 7075, etc.).', 'ar' => 'خفيف الوزن، مقاوم للتآكل، سبائك متعددة.']],
            ['name' => ['en' => 'Alloy Steel', 'ar' => 'سبائك الفولاذ'], 'slug' => 'alloy-steel', 'description' => ['en' => 'Steel alloyed with various elements for enhanced properties.', 'ar' => 'فولاذ مخلوط بعناصر مختلفة لخصائص محسنة.']],
            ['name' => ['en' => 'Brass', 'ar' => 'النحاس الأصفر'], 'slug' => 'brass', 'description' => ['en' => 'Copper-zinc alloy with good machinability and corrosion resistance.', 'ar' => 'سبيكة نحاس-زنك مع قابلية تشغيل جيدة ومقاومة للتآكل.']],
        ];

        // Plastics from PDF
        $plastics = [
            ['name' => ['en' => 'POM (Delrin/Acetal)', 'ar' => 'POM (ديلرين/أسيتال)'], 'slug' => 'pom-delrin', 'description' => ['en' => 'High stiffness, good moisture resistance, high wear-resistance, and low friction.', 'ar' => 'صلابة عالية، مقاومة جيدة للرطوبة، مقاومة عالية للتآكل، واحتكاك منخفض.']],
            ['name' => ['en' => 'ABS', 'ar' => 'ABS'], 'slug' => 'abs', 'description' => ['en' => 'Common thermoplastic, abrasion resistance, high stability, easy to machine.', 'ar' => 'بلاستيك حراري شائع، مقاومة للتآكل، استقرار عالي، سهل التشغيل.']],
            ['name' => ['en' => 'Nylon (PA)', 'ar' => 'نايلون (PA)'], 'slug' => 'nylon', 'description' => ['en' => 'High chemical and heat resistance, high abrasion and wear resistance.', 'ar' => 'مقاومة عالية للمواد الكيميائية والحرارة، مقاومة عالية للتآكل والبلى.']],
            ['name' => ['en' => 'PEEK', 'ar' => 'PEEK'], 'slug' => 'peek', 'description' => ['en' => 'Excellent thermoplastic, very high strength, thermal and chemical resistance.', 'ar' => 'بلاستيك حراري ممتاز، قوة عالية جداً، مقاومة حرارية وكيميائية.']],
            ['name' => ['en' => 'PTFE (Teflon)', 'ar' => 'PTFE (تفلون)'], 'slug' => 'ptfe', 'description' => ['en' => 'Chemical and thermal resistance, low friction coefficient.', 'ar' => 'مقاومة كيميائية وحرارية، معامل احتكاك منخفض.']],
            ['name' => ['en' => 'PVC', 'ar' => 'PVC'], 'slug' => 'pvc', 'description' => ['en' => 'Highly chemical and weather resistant, abrasion-resistant, and good toughness.', 'ar' => 'مقاوم للغاية للمواد الكيميائية والطقس، مقاوم للتآكل، ومتانة جيدة.']],
            ['name' => ['en' => 'PMMA (Acrylic)', 'ar' => 'PMMA (أكريليك)'], 'slug' => 'pmma', 'description' => ['en' => 'Transparent rigid plastic frequently used as a glass substitute.', 'ar' => 'بلاستيك صلب شفاف يستخدم بشكل متكرر كبديل للزجاج.']],
            ['name' => ['en' => 'PEI (Ultem)', 'ar' => 'PEI (ألتم)'], 'slug' => 'pei', 'description' => ['en' => 'High strength, high rigidity, chemical resistance and excellent thermal properties.', 'ar' => 'قوة عالية، صلابة عالية، مقاومة كيميائية وخصائص حرارية ممتازة.']],
            ['name' => ['en' => 'HDPE', 'ar' => 'HDPE'], 'slug' => 'hdpe', 'description' => ['en' => 'High-density polyethylene with excellent chemical resistance.', 'ar' => 'بولي إيثيلين عالي الكثافة مع مقاومة كيميائية ممتازة.']],
            ['name' => ['en' => 'Polypropylene', 'ar' => 'بولي بروبيلين'], 'slug' => 'polypropylene', 'description' => ['en' => 'Lightweight, good chemical resistance, suitable for living hinges.', 'ar' => 'خفيف الوزن، مقاومة كيميائية جيدة، مناسب للمفصلات الحية.']],
            ['name' => ['en' => 'Nylatron', 'ar' => 'نايلاترون'], 'slug' => 'nylatron', 'description' => ['en' => 'MoS2-filled nylon with enhanced wear resistance and reduced friction.', 'ar' => 'نايلون مملوء بـ MoS2 مع مقاومة تآكل محسنة واحتكاك منخفض.']],
            ['name' => ['en' => 'UHMW', 'ar' => 'UHMW'], 'slug' => 'uhmw', 'description' => ['en' => 'Ultra-high molecular weight polyethylene with excellent abrasion resistance.', 'ar' => 'بولي إيثيلين فائق الوزن الجزيئي مع مقاومة تآكل ممتازة.']],
        ];

        foreach ($metals as $index => $material) {
            Material::create(array_merge($material, [
                'material_category_id' => $metalCategory->id,
                'sort_order' => $index + 1
            ]));
        }

        foreach ($plastics as $index => $material) {
            Material::create(array_merge($material, [
                'material_category_id' => $plasticCategory->id,
                'sort_order' => $index + 1
            ]));
        }
    }
}
