<?php

namespace Database\Seeders;

use App\Models\Service;
use App\Models\ServiceSection;
use App\Models\ServiceFaq;
use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    public function run(): void
    {
        $services = [
            [
                'title' => ['en' => 'CNC Manufacturing', 'ar' => 'التصنيع بالتحكم الرقمي'],
                'slug' => 'cnc-manufacturing',
                'excerpt' => [
                    'en' => 'State-of-the-art subtractive and additive CNC machining services for precision components.',
                    'ar' => 'خدمات تصنيع CNC بالإضافة والإزالة الحديثة للمكونات الدقيقة.'
                ],
                'description' => [
                    'en' => 'CNC machining or Computer Numerical Control machining is a manufacturing process in which pre-programmed computer software dictates the movement of factory tools and machinery. Our advanced CNC capabilities include both subtractive and additive manufacturing processes to meet the most demanding precision requirements.',
                    'ar' => 'التصنيع بالتحكم الرقمي هو عملية تصنيع يتحكم فيها برنامج كمبيوتر مبرمج مسبقاً في حركة أدوات وآلات المصنع. تشمل قدراتنا المتقدمة في CNC عمليات التصنيع بالإزالة والإضافة لتلبية أكثر متطلبات الدقة صرامة.'
                ],
                'icon' => 'cog',
                'is_featured' => true,
                'sort_order' => 1,
                'sections' => [
                    [
                        'type' => 'text',
                        'title' => ['en' => 'Subtractive Manufacturing', 'ar' => 'التصنيع بالإزالة'],
                        'content' => [
                            'en' => 'Subtractive machining removes excess material from a workpiece to create a design. Our processes include turning, milling, drilling, boring, sawing, broaching, grinding, and EDM.',
                            'ar' => 'التصنيع بالإزالة يزيل المواد الزائدة من قطعة العمل لإنشاء التصميم. تشمل عملياتنا الخراطة والتفريز والثقب والتوسيع والنشر والتقطيع والطحن والتفريغ الكهربائي.'
                        ],
                        'sort_order' => 1
                    ],
                    [
                        'type' => 'text',
                        'title' => ['en' => 'Additive Manufacturing', 'ar' => 'التصنيع بالإضافة'],
                        'content' => [
                            'en' => 'Additive manufacturing deposits material layer-by-layer to build up a design, commonly known as 3D printing. We offer advanced 3D printing services for rapid prototyping and production parts.',
                            'ar' => 'التصنيع بالإضافة يرسب المواد طبقة تلو الأخرى لبناء التصميم، والمعروف أيضاً بالطباعة ثلاثية الأبعاد. نقدم خدمات طباعة ثلاثية الأبعاد متقدمة للنماذج الأولية السريعة وقطع الإنتاج.'
                        ],
                        'sort_order' => 2
                    ]
                ],
                'faqs' => [
                    [
                        'question' => ['en' => 'What tolerances can you achieve?', 'ar' => 'ما التفاوتات التي يمكنكم تحقيقها؟'],
                        'answer' => ['en' => 'We can achieve tolerances as tight as ±0.001" depending on the material and geometry of the part.', 'ar' => 'يمكننا تحقيق تفاوتات دقيقة تصل إلى ±0.001 بوصة حسب المادة وهندسة القطعة.'],
                        'sort_order' => 1
                    ],
                    [
                        'question' => ['en' => 'What materials do you work with?', 'ar' => 'ما المواد التي تعملون بها؟'],
                        'answer' => ['en' => 'We work with a wide range of metals including titanium, stainless steel, aluminum, brass, and various plastics like PEEK, Delrin, and Nylon.', 'ar' => 'نعمل مع مجموعة واسعة من المعادن بما في ذلك التيتانيوم والفولاذ المقاوم للصدأ والألومنيوم والنحاس الأصفر، ومختلف البلاستيك مثل PEEK وديلرين ونايلون.'],
                        'sort_order' => 2
                    ]
                ]
            ],
            [
                'title' => ['en' => 'Pattern Making', 'ar' => 'صناعة القوالب'],
                'slug' => 'pattern-making',
                'excerpt' => [
                    'en' => 'Advanced patternmaking capabilities for sand casting foundries with CNC precision.',
                    'ar' => 'قدرات متقدمة في صناعة القوالب لمسابك الصب الرملي بدقة CNC.'
                ],
                'description' => [
                    'en' => 'Our captive pattern shop collaborates with our sand-casting foundry to provide comprehensive patternmaking services. We offer precision CNC wood and urethane pattern construction, 3D-printed plastic patterns and sand molds, and robotically milled pattern-less molding.',
                    'ar' => 'تتعاون ورشة القوالب لدينا مع مسبك الصب الرملي لتقديم خدمات صناعة قوالب شاملة. نقدم بناء قوالب خشبية ويوريثان بدقة CNC وقوالب بلاستيكية وقوالب رملية مطبوعة ثلاثية الأبعاد وصب بدون قوالب بالطحن الروبوتي.'
                ],
                'icon' => 'template',
                'is_featured' => true,
                'sort_order' => 2,
                'sections' => [
                    [
                        'type' => 'list',
                        'title' => ['en' => 'Our Capabilities', 'ar' => 'قدراتنا'],
                        'content' => [
                            'en' => "Captive pattern shop collaboration with sand-casting foundry\nPrecision CNC wood and urethane pattern construction\nSand-casting pattern design consultation\nExperienced journeyman sand casting patternmakers\nRobotically milled pattern-less molding\n3D-printed plastic patterns\n3D-printed sand molds\nEngineering changes\nEngineered mounting, gating & rigging systems",
                            'ar' => "تعاون ورشة القوالب مع مسبك الصب الرملي\nبناء قوالب خشبية ويوريثان بدقة CNC\nاستشارات تصميم قوالب الصب الرملي\nصانعو قوالب صب رملي ذوو خبرة\nصب بدون قوالب بالطحن الروبوتي\nقوالب بلاستيكية مطبوعة ثلاثية الأبعاد\nقوالب رملية مطبوعة ثلاثية الأبعاد\nالتغييرات الهندسية\nأنظمة تركيب وبوابات وتجهيز مهندسة"
                        ],
                        'sort_order' => 1
                    ]
                ],
                'faqs' => []
            ],
            [
                'title' => ['en' => 'Reverse Engineering', 'ar' => 'الهندسة العكسية'],
                'slug' => 'reverse-engineering',
                'excerpt' => [
                    'en' => 'Complete reverse engineering services with 100% part duplication capability.',
                    'ar' => 'خدمات هندسة عكسية كاملة مع قدرة على تكرار القطع بنسبة 100%.'
                ],
                'description' => [
                    'en' => 'Our reverse engineering services enable 100% duplication of existing parts. Using advanced 3D scanning and CAD/CAM software, we can recreate any component from an existing sample, even without original drawings or specifications.',
                    'ar' => 'تمكن خدمات الهندسة العكسية لدينا من تكرار القطع الموجودة بنسبة 100%. باستخدام المسح ثلاثي الأبعاد المتقدم وبرامج CAD/CAM، يمكننا إعادة إنشاء أي مكون من عينة موجودة حتى بدون الرسومات أو المواصفات الأصلية.'
                ],
                'icon' => 'refresh',
                'is_featured' => true,
                'sort_order' => 3,
                'sections' => [],
                'faqs' => [
                    [
                        'question' => ['en' => 'Can you duplicate parts without original drawings?', 'ar' => 'هل يمكنكم تكرار القطع بدون الرسومات الأصلية؟'],
                        'answer' => ['en' => 'Yes, we can duplicate any part using 3D scanning technology and reverse engineering techniques.', 'ar' => 'نعم، يمكننا تكرار أي قطعة باستخدام تقنية المسح ثلاثي الأبعاد وتقنيات الهندسة العكسية.'],
                        'sort_order' => 1
                    ]
                ]
            ]
        ];

        foreach ($services as $serviceData) {
            $sections = $serviceData['sections'] ?? [];
            $faqs = $serviceData['faqs'] ?? [];
            unset($serviceData['sections'], $serviceData['faqs']);

            $service = Service::create($serviceData);

            foreach ($sections as $sectionData) {
                $service->sections()->create($sectionData);
            }

            foreach ($faqs as $faqData) {
                $service->faqs()->create($faqData);
            }
        }
    }
}
