<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            // General Settings
            ['key' => 'site_name', 'value' => 'AISCo - Advanced Industrial Services Co', 'group' => 'general'],
            ['key' => 'site_name_ar', 'value' => 'أيسكو - شركة الخدمات المتطورة للصناعة', 'group' => 'general'],
            ['key' => 'site_tagline', 'value' => 'Precision CNC Factory', 'group' => 'general'],
            ['key' => 'site_tagline_ar', 'value' => 'مصنع التحكم الرقمي الدقيق', 'group' => 'general'],
            ['key' => 'site_description', 'value' => 'Igniting sparks to start real manufacturing in KSA', 'group' => 'general'],
            ['key' => 'site_description_ar', 'value' => 'نشعل شرارة التصنيع الحقيقي في المملكة العربية السعودية', 'group' => 'general'],

            // Contact Information
            ['key' => 'contact_email', 'value' => 'info@aiscksa.com', 'group' => 'contact'],
            ['key' => 'contact_email_sales', 'value' => 'hummam@aiscksa.com', 'group' => 'contact'],
            ['key' => 'contact_phone', 'value' => '+966 505 622 994', 'group' => 'contact'],
            ['key' => 'contact_phone_office', 'value' => '+966 12 261 4100', 'group' => 'contact'],
            ['key' => 'contact_whatsapp', 'value' => '966505622994', 'group' => 'contact'],
            ['key' => 'contact_address', 'value' => 'Jeddah, Kingdom of Saudi Arabia', 'group' => 'contact'],
            ['key' => 'contact_address_ar', 'value' => 'جدة، المملكة العربية السعودية', 'group' => 'contact'],
            ['key' => 'working_hours', 'value' => 'Sunday - Thursday: 8:00 AM - 5:00 PM', 'group' => 'contact'],
            ['key' => 'working_hours_ar', 'value' => 'الأحد - الخميس: 8:00 صباحاً - 5:00 مساءً', 'group' => 'contact'],

            // Social Media
            ['key' => 'social_linkedin', 'value' => 'https://linkedin.com/company/aisco', 'group' => 'social'],
            ['key' => 'social_twitter', 'value' => 'https://twitter.com/aisco', 'group' => 'social'],
            ['key' => 'social_youtube', 'value' => '', 'group' => 'social'],
            ['key' => 'social_instagram', 'value' => '', 'group' => 'social'],

            // Form Recipients
            ['key' => 'contact_form_email', 'value' => 'info@aiscksa.com', 'group' => 'forms'],
            ['key' => 'quote_form_email', 'value' => 'hummam@aiscksa.com', 'group' => 'forms'],
            ['key' => 'careers_form_email', 'value' => 'hr@aiscksa.com', 'group' => 'forms'],

            // SEO
            ['key' => 'seo_meta_title', 'value' => 'AISCo - Precision CNC Manufacturing in Saudi Arabia', 'group' => 'seo'],
            ['key' => 'seo_meta_description', 'value' => 'Advanced Industrial Services Co provides precision CNC machining, pattern making, and reverse engineering services in Saudi Arabia.', 'group' => 'seo'],
            ['key' => 'seo_meta_keywords', 'value' => 'CNC machining, precision manufacturing, Saudi Arabia, aerospace, medical devices, oil and gas', 'group' => 'seo'],
            ['key' => 'google_analytics_id', 'value' => '', 'group' => 'seo'],

            // Features
            ['key' => 'feature_blog_enabled', 'value' => 'true', 'group' => 'features'],
            ['key' => 'feature_careers_enabled', 'value' => 'true', 'group' => 'features'],
            ['key' => 'feature_testimonials_enabled', 'value' => 'true', 'group' => 'features'],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                ['value' => $setting['value'], 'group' => $setting['group']]
            );
        }
    }
}
