<?php

return [
    // General
    'home' => 'Home',
    'about' => 'About',
    'about_us' => 'About Us',
    'services' => 'Services',
    'industries' => 'Industries',
    'projects' => 'Projects',
    'portfolio' => 'Portfolio',
    'news' => 'News',
    'blog' => 'Blog',
    'careers' => 'Careers',
    'contact' => 'Contact',
    'contact_us' => 'Contact Us',
    'request_quote' => 'Request Quote',
    'get_quote' => 'Get a Quote',
    'learn_more' => 'Learn More',
    'view_all' => 'View All',
    'read_more' => 'Read More',
    'submit' => 'Submit',
    'send_message' => 'Send Message',
    'search' => 'Search',
    'loading' => 'Loading...',
    
    // Company Info
    'company_name' => 'AISCo',
    'company_full_name' => 'Advanced Industrial Services Co',
    'company_arabic_name' => 'شركة الخدمات المتطورة للصناعة',
    'precision_cnc_factory' => 'Precision CNC Factory',
    'tagline' => 'Igniting sparks to start real manufacturing in KSA',
    'about_aisc' => 'About AISCo',
    'who_we_are' => 'Who We Are',
    
    // Hero Section
    'hero_title' => 'Precision CNC Manufacturing',
    'hero_subtitle' => 'Excellence in KSA',
    'hero_description' => 'Advanced Industrial Services Co delivers world-class CNC machining solutions with unmatched precision, rapid delivery, and significant cost savings.',
    'explore_services' => 'Explore Services',
    
    // About Page
    'about_meta_description' => 'Learn about Advanced Industrial Services Co (AISCo) - Precision CNC Factory igniting sparks to start real manufacturing in KSA.',
    'about_paragraph_1' => 'AISC (Advanced Industrial Services Co) is a leading precision CNC manufacturing facility in Saudi Arabia, dedicated to bringing world-class machining capabilities to the Kingdom. We are committed to supporting the local manufacturing sector by providing high-quality, precision-engineered components across multiple industries.',
    'about_paragraph_2' => 'Our state-of-the-art facility is equipped with advanced CNC machines, wire EDM, and Ram/Plunge/Sink EDM technology capable of achieving exacting tolerances for the most demanding applications. From aerospace components to medical devices, we deliver excellence in every part we manufacture.',
    'about_paragraph_3' => 'Founded with the vision of reducing Saudi Arabia\'s dependence on imported machined parts, we offer rapid manufacturing solutions that deliver significant cost savings and dramatically reduced lead times compared to overseas suppliers.',
    'factory_image' => 'AISCo Factory',
    
    // Value Propositions
    'why_choose_us' => 'Why Choose Us',
    'our_advantages' => 'The AISC Advantage',
    'cost_savings' => 'Cost Savings',
    'weeks_delivery' => 'Weeks Delivery',
    'cost_effective' => 'Cost Effective',
    'cost_effective_desc' => 'Save up to 69% compared to international sourcing with local manufacturing excellence.',
    'rapid_delivery' => 'Rapid Delivery',
    'rapid_delivery_desc' => '4-week delivery vs 6-9 months from overseas. Get your parts when you need them.',
    'certified_quality' => 'Certified Quality',
    'certified_quality_desc' => 'All parts are certified and manufactured to meet the highest industry standards.',
    'local_expertise' => 'Local Expertise',
    'local_expertise_desc' => 'Based in Saudi Arabia, supporting Vision 2030 and local manufacturing growth.',
    
    // Case Study
    'real_example' => 'Real Example',
    'helicopter_parts_title' => 'Helicopter Rotary Assembly Parts',
    'helicopter_parts_desc' => 'Parts urgently needed for helicopter rotary assembly. Traditional US sourcing would take 6-9 months at $92,700. AISC delivered all 6 certified parts in just 4 weeks at $28,600.',
    'helicopter_parts' => 'Helicopter Parts',
    'traditional_sourcing' => 'Traditional Sourcing',
    'aisc_solution' => 'AISC Solution',
    'months' => 'months',
    'weeks' => 'weeks',
    
    // Vision & Mission
    'our_vision' => 'Our Vision',
    'vision_text' => 'To be the leading precision manufacturing partner in the Middle East, driving industrial self-sufficiency and innovation in Saudi Arabia while delivering world-class quality and unmatched value to our clients across all sectors.',
    'our_mission' => 'Our Mission',
    'mission_text' => 'To provide rapid, cost-effective precision manufacturing solutions using state-of-the-art CNC technology, while nurturing local talent and contributing to the Kingdom\'s industrial diversification goals under Vision 2030.',
    
    // Services
    'our_services' => 'Our Services',
    'services_subtitle' => 'Comprehensive CNC manufacturing solutions for every industry',
    'cnc_manufacturing' => 'CNC Manufacturing',
    'cnc_manufacturing_desc' => 'State-of-the-art subtractive and additive CNC machining services for precision components.',
    'pattern_making' => 'Pattern Making',
    'pattern_making_desc' => 'Advanced patternmaking capabilities for sand casting foundries with CNC precision.',
    'reverse_engineering' => 'Reverse Engineering',
    'reverse_engineering_desc' => 'Complete reverse engineering services with 100% part duplication capability.',
    'polytechnic_education' => 'Polytechnic Education',
    'polytechnic_education_desc' => 'Training programs to develop local CNC machining talent in Saudi Arabia.',
    
    // CNC Types
    'subtractive_manufacturing' => 'Subtractive Manufacturing',
    'subtractive_desc' => 'Removing material from workpiece',
    'additive_manufacturing' => 'Additive Manufacturing',
    'additive_desc' => 'Depositing material layer by layer',
    
    // CNC Processes
    'cnc_processes' => 'CNC Machining Processes',
    'turning' => 'Turning',
    'turning_desc' => 'Rotating the workpiece to bring metal in contact with the cutting tool using lathes.',
    'milling' => 'Milling',
    'milling_desc' => 'Rotating a cutting tool to bring it into contact with a stationary workpiece.',
    'drilling' => 'Drilling',
    'drilling_desc' => 'Creating or refining holes by bringing a rotating cutting tool into contact with the workpiece.',
    'boring' => 'Boring',
    'boring_desc' => 'Removing material to form highly accurate and precise inner cavities.',
    'sawing' => 'Sawing',
    'sawing_desc' => 'Cutting a narrow slit in a workpiece using a saw blade as a cutting tool.',
    'broaching' => 'Broaching',
    'broaching_desc' => 'Removing material through a series of shallow cuts using a tool with many teeth.',
    'grinding' => 'Grinding',
    'grinding_desc' => 'Bringing a workpiece in contact with a rotating abrasive surface to smooth surfaces.',
    'edm' => 'EDM',
    'edm_desc' => 'Electrical Discharge Machining - using electrical discharges to machine features on a mold.',
    
    // Pattern Making
    'pattern_making_title' => 'Pattern Making',
    'sand_casting_foundry' => 'Sand Casting Foundry with Advanced Patternmaking Capabilities',
    'pattern_feature_1' => 'Captive pattern shop collaborates with our sand-casting foundry',
    'pattern_feature_2' => 'Precision CNC wood and urethane pattern construction',
    'pattern_feature_3' => 'Sand-casting pattern design consultation',
    'pattern_feature_4' => 'Experienced journeyman sand casting patternmakers',
    'pattern_feature_5' => 'Robotically milled pattern-less molding using our in-house robot and CNC machining',
    'pattern_feature_6' => '3D-printed plastic patterns',
    'pattern_feature_7' => '3D-printed sand molds',
    'pattern_feature_8' => 'Engineering changes',
    'pattern_feature_9' => 'Engineered mounting, gating & rigging systems',
    
    // Industries
    'industries_we_serve' => 'Industries We Serve',
    'industries_subtitle' => 'Precision machining is used across several industries to produce components with fast manufacturing times and repeatable accuracy',
    'aircrafts' => 'Aircrafts',
    'aircrafts_desc' => 'Superior machined components for aircraft and jet applications with exacting tolerances.',
    'military' => 'Military',
    'military_desc' => 'Precision parts manufactured for military applications with highest quality materials.',
    'aerospace' => 'Aerospace',
    'aerospace_desc' => 'Aerospace components manufactured with superior machining processes and incredible accuracy.',
    'medical_devices' => 'Medical Devices',
    'medical_devices_desc' => 'Ultra precision machine work for the medical industry including surgical instruments and implants.',
    'optical_equipment' => 'Optical Equipment',
    'optical_equipment_desc' => 'CNC machining services benefiting the optical industry with highest precision and accuracy.',
    'pattern_making_industry' => 'Pattern Making',
    'pattern_making_industry_desc' => 'Sand casting foundry with advanced patternmaking capabilities.',
    'pharmaceuticals' => 'Pharmaceuticals',
    'pharmaceuticals_desc' => 'Achieve the impossible with the best CNC machines in the industry for pharmaceutical equipment.',
    'general_spare_parts' => 'General Spare Parts',
    'general_spare_parts_desc' => 'Rapid prototyping and mass production service for automotive and general spare parts.',
    'oil_gas' => 'Oil & Gas',
    'oil_gas_desc' => 'Solutions to the complex component challenges of the oil industry with ultra-precision components.',
    
    // Materials
    'materials' => 'Materials',
    'materials_we_work_with' => 'Materials We Work With',
    'materials_subtitle' => 'High-quality CNC machining materials for all applications',
    'metals' => 'Metals',
    'plastics' => 'Plastics',
    'choosing_best_material' => 'Choosing the Best Material',
    'material_selection_desc' => 'Determining which CNC material will work best for your component or prototype can be difficult. AISC is experienced in machining a wide variety of components from hundreds of different materials.',
    
    // Metal Materials
    'titanium' => 'Titanium',
    'tungsten' => 'Tungsten',
    'vim_var' => 'VIM VAR',
    'waspaloy' => 'Waspaloy',
    'nickel_200' => 'Nickel 200',
    'rhenium' => 'Rhenium',
    'stainless_steel' => 'Stainless Steel',
    'stavax' => 'Stavax',
    'bronze' => 'Bronze',
    'carbon_steel' => 'Carbon Steel',
    'copper' => 'Copper',
    'hardened_steel' => 'Hardened Steel',
    'kovar' => 'Kovar',
    'maraging_steel' => 'Maraging Steel',
    'molybdenum' => 'Molybdenum',
    'monel' => 'Monel',
    'aluminum' => 'Aluminum',
    'alloy_steel' => 'Alloy Steel',
    'brass' => 'Brass',
    
    // Plastic Materials
    'pom_delrin' => 'POM (Delrin/Acetal)',
    'pom_desc' => 'High stiffness, good moisture resistance, high wear-resistance, and low friction',
    'abs' => 'ABS',
    'abs_desc' => 'Common thermoplastic, abrasion resistance, high stability, easy to machine',
    'nylon' => 'Nylon (PA)',
    'nylon_desc' => 'High chemical and heat resistance, high abrasion and wear resistance',
    'peek' => 'PEEK',
    'peek_desc' => 'Excellent thermoplastic, very high strength, thermal and chemical resistance',
    'ptfe' => 'PTFE (Teflon)',
    'ptfe_desc' => 'Chemical and thermal resistance, low friction',
    'pvc' => 'PVC',
    'pvc_desc' => 'Highly chemical and weather resistant, abrasion-resistant, and good toughness',
    'pmma' => 'PMMA (Acrylic)',
    'pmma_desc' => 'Transparent rigid plastic frequently used as a glass substitute',
    'pei' => 'PEI (Ultem)',
    'pei_desc' => 'High strength, high rigidity, chemical resistance and excellent thermal properties',
    'hdpe' => 'HDPE',
    'polypropylene' => 'Polypropylene',
    'nylatron' => 'Nylatron',
    'uhmw' => 'UHMW',
    
    // Projects
    'our_projects' => 'Our Projects',
    'featured_projects' => 'Featured Projects',
    'projects_subtitle' => 'Explore our portfolio of precision-engineered components',
    'view_project' => 'View Project',
    'project_details' => 'Project Details',
    'project_gallery' => 'Project Gallery',
    'all_categories' => 'All Categories',
    
    // Blog
    'latest_news' => 'Latest News',
    'news_insights' => 'News & Insights',
    'blog_subtitle' => 'Stay updated with the latest from AISCo and the manufacturing industry',
    'posted_on' => 'Posted on',
    'by_author' => 'by',
    'read_article' => 'Read Article',
    'categories' => 'Categories',
    'tags' => 'Tags',
    'recent_posts' => 'Recent Posts',
    'no_posts' => 'No posts found.',
    
    // Contact
    'get_in_touch' => 'Get in Touch',
    'contact_subtitle' => 'Have a question or need a quote? We\'re here to help.',
    'contact_info' => 'Contact Information',
    'our_location' => 'Our Location',
    'phone' => 'Phone',
    'email' => 'Email',
    'working_hours' => 'Working Hours',
    'working_hours_value' => 'Sunday - Thursday: 8:00 AM - 5:00 PM',
    'send_us_message' => 'Send Us a Message',
    'your_name' => 'Your Name',
    'your_email' => 'Your Email',
    'your_phone' => 'Your Phone',
    'company_name_field' => 'Company Name',
    'subject' => 'Subject',
    'message' => 'Message',
    'message_placeholder' => 'Tell us about your project or inquiry...',
    'message_sent' => 'Your message has been sent successfully!',
    'message_error' => 'There was an error sending your message. Please try again.',
    
    // Quote Form
    'request_quote_title' => 'Request a Quote',
    'quote_subtitle' => 'Get a free quote for your precision manufacturing needs',
    'project_type' => 'Project Type',
    'quantity' => 'Quantity',
    'deadline' => 'Deadline',
    'upload_files' => 'Upload Files',
    'upload_files_desc' => 'Upload CAD files, drawings, or specifications (Max 10MB)',
    'additional_details' => 'Additional Details',
    'quote_received' => 'Your quote request has been received! We will contact you shortly.',
    
    // Careers
    'careers_title' => 'Careers at AISCo',
    'careers_subtitle' => 'Join our team and be part of Saudi Arabia\'s manufacturing revolution',
    'open_positions' => 'Open Positions',
    'no_openings' => 'No current openings. Please check back later.',
    'apply_now' => 'Apply Now',
    'job_details' => 'Job Details',
    'requirements' => 'Requirements',
    'responsibilities' => 'Responsibilities',
    'upload_cv' => 'Upload CV',
    'cover_letter' => 'Cover Letter',
    'application_submitted' => 'Your application has been submitted successfully!',
    
    // Footer
    'quick_links' => 'Quick Links',
    'our_services_footer' => 'Our Services',
    'contact_info_footer' => 'Contact Info',
    'newsletter' => 'Newsletter',
    'newsletter_desc' => 'Subscribe to our newsletter for updates',
    'enter_email' => 'Enter your email',
    'subscribe' => 'Subscribe',
    'all_rights_reserved' => 'All rights reserved.',
    'privacy_policy' => 'Privacy Policy',
    'terms_conditions' => 'Terms & Conditions',
    
    // CTA
    'ready_to_start' => 'Ready to Start Your Project?',
    'cta_description' => 'Contact us today to discuss your precision manufacturing needs and get a free quote.',
    
    // Partners
    'our_partners' => 'Our Partners',
    'trusted_by' => 'Trusted by Industry Leaders',
    
    // Testimonials
    'testimonials' => 'Testimonials',
    'what_clients_say' => 'What Our Clients Say',
    
    // 404
    'page_not_found' => 'Page Not Found',
    'page_not_found_desc' => 'The page you are looking for might have been removed or is temporarily unavailable.',
    'back_to_home' => 'Back to Home',
    
    // Validation Messages
    'required_field' => 'This field is required.',
    'invalid_email' => 'Please enter a valid email address.',
    'file_too_large' => 'The file is too large. Maximum size is 10MB.',
    
    // Success Messages
    'thank_you' => 'Thank You!',
    'form_submitted' => 'Your form has been submitted successfully.',
    
    // Misc
    'featured' => 'Featured',
    'new' => 'New',
    'popular' => 'Popular',
    'share' => 'Share',
    'print' => 'Print',
    'download' => 'Download',
    'close' => 'Close',
    'previous' => 'Previous',
    'next' => 'Next',
];
