@extends('frontend.layouts.app')

@section('title', __('messages.about_us') . ' - ' . config('app.name'))
@section('meta_description', __('messages.about_meta_description'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[50vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <span class="inline-block px-4 py-1 bg-primary-500/20 text-primary-400 text-sm font-semibold rounded-full mb-6">
                {{ __('messages.about_aisc') }}
            </span>
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
                {{ __('messages.precision_cnc_factory') }}
            </h1>
            <p class="text-xl md:text-2xl text-slate-300 leading-relaxed">
                {{ __('messages.tagline') }}
            </p>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Company Overview -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div class="order-2 lg:order-1">
                <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">{{ __('messages.who_we_are') }}</span>
                <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mt-2 mb-6">
                    {{ __('messages.company_full_name') }}
                </h2>
                <div class="prose prose-lg text-slate-600 space-y-4">
                    <p>{{ __('messages.about_paragraph_1') }}</p>
                    <p>{{ __('messages.about_paragraph_2') }}</p>
                    <p>{{ __('messages.about_paragraph_3') }}</p>
                </div>
            </div>
            <div class="relative order-1 lg:order-2">
                <div class="aspect-[4/3] rounded-2xl overflow-hidden shadow-2xl">
                    <img src="{{ asset('images/about/factory.jpg') }}" alt="{{ __('messages.factory_image') }}" class="w-full h-full object-cover" onerror="this.src='https://images.unsplash.com/photo-1581091226825-a6a2a5aee158?w=800'">
                </div>
                <div class="absolute -bottom-8 {{ app()->getLocale() === 'ar' ? '-right-4 lg:-right-8' : '-left-4 lg:-left-8' }} bg-primary-600 text-white p-4 lg:p-6 rounded-xl shadow-xl">
                    <div class="text-3xl lg:text-4xl font-bold">69%</div>
                    <div class="text-xs lg:text-sm text-primary-100">{{ __('messages.cost_savings') }}</div>
                </div>
                <div class="absolute -top-8 {{ app()->getLocale() === 'ar' ? '-left-4 lg:-left-8' : '-right-4 lg:-right-8' }} bg-slate-900 text-white p-4 lg:p-6 rounded-xl shadow-xl">
                    <div class="text-3xl lg:text-4xl font-bold">4</div>
                    <div class="text-xs lg:text-sm text-slate-300">{{ __('messages.weeks_delivery') }}</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Value Propositions -->
<section class="py-20 bg-slate-50">
    <div class="container mx-auto px-4">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">{{ __('messages.why_choose_us') }}</span>
            <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mt-2 mb-4">
                {{ __('messages.our_advantages') }}
            </h2>
        </div>
        
        <!-- Case Study Highlight -->
        <div class="bg-gradient-to-r from-slate-900 to-primary-900 rounded-3xl overflow-hidden mb-16">
            <div class="grid lg:grid-cols-2 gap-0">
                <div class="p-8 lg:p-12 flex flex-col justify-center">
                    <span class="text-primary-400 font-semibold text-sm uppercase tracking-wider">{{ __('messages.real_example') }}</span>
                    <h3 class="text-2xl md:text-3xl font-bold text-white mt-2 mb-4">
                        {{ __('messages.helicopter_parts_title') }}
                    </h3>
                    <p class="text-slate-300 mb-6">{{ __('messages.helicopter_parts_desc') }}</p>
                    <div class="grid grid-cols-2 gap-4 lg:gap-6">
                        <div class="bg-white/10 backdrop-blur rounded-xl p-4">
                            <div class="text-red-400 text-sm mb-1">{{ __('messages.traditional_sourcing') }}</div>
                            <div class="text-xl lg:text-2xl font-bold text-white">$92,700</div>
                            <div class="text-slate-400 text-sm">6-9 {{ __('messages.months') }}</div>
                        </div>
                        <div class="bg-primary-500/20 rounded-xl p-4 border border-primary-500/30">
                            <div class="text-primary-400 text-sm mb-1">{{ __('messages.aisc_solution') }}</div>
                            <div class="text-xl lg:text-2xl font-bold text-white">$28,600</div>
                            <div class="text-primary-300 text-sm">4 {{ __('messages.weeks') }}</div>
                        </div>
                    </div>
                </div>
                <div class="relative h-64 lg:h-auto">
                    <img src="{{ asset('images/about/helicopter-parts.jpg') }}" alt="{{ __('messages.helicopter_parts') }}" class="absolute inset-0 w-full h-full object-cover" onerror="this.src='https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=800'">
                    <div class="absolute inset-0 bg-gradient-to-{{ app()->getLocale() === 'ar' ? 'l' : 'r' }} from-slate-900/50 to-transparent"></div>
                </div>
            </div>
        </div>
        
        <!-- Advantages Grid -->
        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow text-center">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4 mx-auto">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-slate-900 mb-2">{{ __('messages.cost_effective') }}</h3>
                <p class="text-slate-600">{{ __('messages.cost_effective_desc') }}</p>
            </div>
            
            <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow text-center">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4 mx-auto">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-slate-900 mb-2">{{ __('messages.rapid_delivery') }}</h3>
                <p class="text-slate-600">{{ __('messages.rapid_delivery_desc') }}</p>
            </div>
            
            <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow text-center">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4 mx-auto">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-slate-900 mb-2">{{ __('messages.certified_quality') }}</h3>
                <p class="text-slate-600">{{ __('messages.certified_quality_desc') }}</p>
            </div>
            
            <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow text-center">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4 mx-auto">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-slate-900 mb-2">{{ __('messages.local_expertise') }}</h3>
                <p class="text-slate-600">{{ __('messages.local_expertise_desc') }}</p>
            </div>
        </div>
    </div>
</section>

<!-- Vision & Mission -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid lg:grid-cols-2 gap-8 lg:gap-12">
            <div class="bg-gradient-to-br from-primary-600 to-primary-700 rounded-2xl p-8 lg:p-10 text-white">
                <div class="w-16 h-16 bg-white/20 rounded-xl flex items-center justify-center mb-6">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold mb-4">{{ __('messages.our_vision') }}</h3>
                <p class="text-primary-100 text-lg leading-relaxed">{{ __('messages.vision_text') }}</p>
            </div>
            
            <div class="bg-gradient-to-br from-slate-800 to-slate-900 rounded-2xl p-8 lg:p-10 text-white">
                <div class="w-16 h-16 bg-white/20 rounded-xl flex items-center justify-center mb-6">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold mb-4">{{ __('messages.our_mission') }}</h3>
                <p class="text-slate-300 text-lg leading-relaxed">{{ __('messages.mission_text') }}</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-700">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">{{ __('messages.ready_to_start') }}</h2>
        <p class="text-xl text-primary-100 mb-8 max-w-2xl mx-auto">{{ __('messages.cta_description') }}</p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('quote') }}" class="inline-flex items-center justify-center px-8 py-3 bg-white text-primary-600 font-semibold rounded-lg hover:bg-primary-50 transition-colors">
                {{ __('messages.request_quote') }}
            </a>
            <a href="{{ route('contact') }}" class="inline-flex items-center justify-center px-8 py-3 border-2 border-white text-white font-semibold rounded-lg hover:bg-white/10 transition-colors">
                {{ __('messages.contact_us') }}
            </a>
        </div>
    </div>
</section>
@endsection
