@extends('frontend.layouts.app')

@section('title', __('messages.blog') . ' - ' . config('app.name'))
@section('meta_description', __('messages.blog_subtitle'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[35vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-16">
        <div class="max-w-4xl mx-auto text-center">
            <h1 class="text-4xl md:text-5xl font-bold text-white mb-4">
                {{ __('messages.news_insights') }}
            </h1>
            <p class="text-xl text-slate-300">
                {{ __('messages.blog_subtitle') }}
            </p>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Blog Content -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid lg:grid-cols-3 gap-8">
            <!-- Posts -->
            <div class="lg:col-span-2">
                @if(isset($posts) && $posts->count() > 0)
                    <div class="space-y-8">
                        @foreach($posts as $post)
                            <article class="bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-xl transition-shadow">
                                <a href="{{ route('blog.show', $post->slug) }}" class="block">
                                    <div class="aspect-[16/9] overflow-hidden">
                                        <img src="{{ $post->featured_image ?? 'https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=800' }}" 
                                             alt="{{ $post->getTranslation('title', app()->getLocale()) }}" 
                                             class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                                    </div>
                                </a>
                                <div class="p-6">
                                    <div class="flex items-center gap-4 text-sm text-slate-500 mb-3">
                                        @if($post->category)
                                            <a href="{{ route('blog.category', $post->category->slug) }}" class="text-primary-600 hover:text-primary-700">
                                                {{ $post->category->getTranslation('name', app()->getLocale()) }}
                                            </a>
                                            <span>•</span>
                                        @endif
                                        <span>{{ $post->published_at->format('M d, Y') }}</span>
                                    </div>
                                    <a href="{{ route('blog.show', $post->slug) }}">
                                        <h2 class="text-xl font-bold text-slate-900 mb-3 hover:text-primary-600 transition-colors">
                                            {{ $post->getTranslation('title', app()->getLocale()) }}
                                        </h2>
                                    </a>
                                    <p class="text-slate-600 mb-4 line-clamp-3">
                                        {{ $post->getTranslation('excerpt', app()->getLocale()) }}
                                    </p>
                                    <a href="{{ route('blog.show', $post->slug) }}" class="inline-flex items-center gap-2 text-primary-600 font-semibold hover:text-primary-700 transition-colors">
                                        {{ __('messages.read_more') }}
                                        <svg class="w-4 h-4 {{ app()->getLocale() === 'ar' ? 'rotate-180' : '' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                                        </svg>
                                    </a>
                                </div>
                            </article>
                        @endforeach
                    </div>
                    
                    <!-- Pagination -->
                    @if($posts->hasPages())
                        <div class="mt-12">
                            {{ $posts->links() }}
                        </div>
                    @endif
                @else
                    <div class="text-center py-16 bg-slate-50 rounded-2xl">
                        <svg class="w-16 h-16 text-slate-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                        </svg>
                        <h3 class="text-xl font-semibold text-slate-900 mb-2">{{ __('messages.no_posts') }}</h3>
                    </div>
                @endif
            </div>
            
            <!-- Sidebar -->
            <div class="lg:col-span-1">
                <!-- Search -->
                <div class="bg-slate-50 rounded-2xl p-6 mb-8">
                    <h3 class="text-lg font-bold text-slate-900 mb-4">{{ __('messages.search') }}</h3>
                    <form action="{{ route('blog.index') }}" method="GET">
                        <div class="relative">
                            <input type="text" name="q" value="{{ request('q') }}" 
                                   placeholder="{{ app()->getLocale() === 'ar' ? 'ابحث في المقالات...' : 'Search articles...' }}"
                                   class="w-full px-4 py-3 pr-12 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500">
                            <button type="submit" class="absolute {{ app()->getLocale() === 'ar' ? 'left-3' : 'right-3' }} top-1/2 -translate-y-1/2 text-slate-400 hover:text-primary-600">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>
                
                <!-- Categories -->
                @if(isset($categories) && $categories->count() > 0)
                    <div class="bg-slate-50 rounded-2xl p-6 mb-8">
                        <h3 class="text-lg font-bold text-slate-900 mb-4">{{ __('messages.categories') }}</h3>
                        <ul class="space-y-2">
                            @foreach($categories as $category)
                                <li>
                                    <a href="{{ route('blog.category', $category->slug) }}" 
                                       class="flex items-center justify-between text-slate-600 hover:text-primary-600 transition-colors py-2">
                                        <span>{{ $category->getTranslation('name', app()->getLocale()) }}</span>
                                        <span class="bg-slate-200 text-slate-600 text-sm px-2 py-1 rounded-full">{{ $category->posts_count ?? 0 }}</span>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                <!-- Recent Posts -->
                @if(isset($recentPosts) && $recentPosts->count() > 0)
                    <div class="bg-slate-50 rounded-2xl p-6">
                        <h3 class="text-lg font-bold text-slate-900 mb-4">{{ __('messages.recent_posts') }}</h3>
                        <div class="space-y-4">
                            @foreach($recentPosts as $recent)
                                <a href="{{ route('blog.show', $recent->slug) }}" class="flex gap-4 group">
                                    <div class="w-20 h-20 flex-shrink-0 rounded-lg overflow-hidden">
                                        <img src="{{ $recent->featured_image ?? 'https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=200' }}" 
                                             alt="{{ $recent->getTranslation('title', app()->getLocale()) }}"
                                             class="w-full h-full object-cover">
                                    </div>
                                    <div class="flex-1">
                                        <h4 class="font-semibold text-slate-900 line-clamp-2 group-hover:text-primary-600 transition-colors">
                                            {{ $recent->getTranslation('title', app()->getLocale()) }}
                                        </h4>
                                        <span class="text-sm text-slate-500">{{ $recent->published_at->format('M d, Y') }}</span>
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</section>
@endsection
