@extends('frontend.layouts.app')

@section('title', ($post->getTranslation('title', app()->getLocale()) ?? __('messages.blog')) . ' - ' . config('app.name'))
@section('meta_description', $post->getTranslation('excerpt', app()->getLocale()) ?? '')

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[45vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-20">
        @if($post->featured_image)
            <img src="{{ $post->featured_image }}" alt="" class="w-full h-full object-cover">
        @endif
    </div>
    <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/80 to-slate-900/60"></div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <nav class="mb-6">
                <ol class="flex items-center justify-center gap-2 text-sm text-slate-400">
                    <li><a href="{{ route('home') }}" class="hover:text-white">{{ __('messages.home') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li><a href="{{ route('blog.index') }}" class="hover:text-white">{{ __('messages.blog') }}</a></li>
                    @if($post->category)
                        <li><span class="mx-2">/</span></li>
                        <li><a href="{{ route('blog.category', $post->category->slug) }}" class="hover:text-white">{{ $post->category->getTranslation('name', app()->getLocale()) }}</a></li>
                    @endif
                </ol>
            </nav>
            <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold text-white mb-6">
                {{ $post->getTranslation('title', app()->getLocale()) }}
            </h1>
            <div class="flex items-center justify-center gap-4 text-slate-400">
                @if($post->author)
                    <span>{{ __('messages.by_author') }} {{ $post->author->name }}</span>
                    <span>•</span>
                @endif
                <span>{{ $post->published_at->format('M d, Y') }}</span>
                @if($post->reading_time)
                    <span>•</span>
                    <span>{{ $post->reading_time }} {{ app()->getLocale() === 'ar' ? 'دقيقة قراءة' : 'min read' }}</span>
                @endif
            </div>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Article Content -->
<article class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-3xl mx-auto">
            <!-- Featured Image -->
            @if($post->featured_image)
                <div class="aspect-[16/9] rounded-2xl overflow-hidden mb-12 shadow-lg">
                    <img src="{{ $post->featured_image }}" alt="{{ $post->getTranslation('title', app()->getLocale()) }}" class="w-full h-full object-cover">
                </div>
            @endif
            
            <!-- Content -->
            <div class="prose prose-lg max-w-none prose-headings:text-slate-900 prose-p:text-slate-600 prose-a:text-primary-600 prose-img:rounded-xl">
                {!! $post->getTranslation('content', app()->getLocale()) !!}
            </div>
            
            <!-- Tags -->
            @if($post->tags && $post->tags->count() > 0)
                <div class="mt-12 pt-8 border-t border-slate-200">
                    <div class="flex flex-wrap items-center gap-2">
                        <span class="text-slate-600 font-medium">{{ __('messages.tags') }}:</span>
                        @foreach($post->tags as $tag)
                            <a href="{{ route('blog.tag', $tag->slug) }}" class="px-3 py-1 bg-slate-100 text-slate-700 text-sm rounded-full hover:bg-primary-100 hover:text-primary-700 transition-colors">
                                {{ $tag->getTranslation('name', app()->getLocale()) }}
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif
            
            <!-- Share -->
            <div class="mt-8 pt-8 border-t border-slate-200">
                <div class="flex items-center justify-between">
                    <span class="text-slate-600 font-medium">{{ __('messages.share') }}:</span>
                    <div class="flex items-center gap-3">
                        <a href="https://twitter.com/intent/tweet?url={{ urlencode(request()->url()) }}&text={{ urlencode($post->getTranslation('title', app()->getLocale())) }}" 
                           target="_blank" rel="noopener" 
                           class="w-10 h-10 bg-slate-100 rounded-full flex items-center justify-center text-slate-600 hover:bg-primary-100 hover:text-primary-600 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84"/></svg>
                        </a>
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode(request()->url()) }}&title={{ urlencode($post->getTranslation('title', app()->getLocale())) }}" 
                           target="_blank" rel="noopener" 
                           class="w-10 h-10 bg-slate-100 rounded-full flex items-center justify-center text-slate-600 hover:bg-primary-100 hover:text-primary-600 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg>
                        </a>
                        <a href="mailto:?subject={{ urlencode($post->getTranslation('title', app()->getLocale())) }}&body={{ urlencode(request()->url()) }}" 
                           class="w-10 h-10 bg-slate-100 rounded-full flex items-center justify-center text-slate-600 hover:bg-primary-100 hover:text-primary-600 transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Author Box -->
            @if($post->author)
                <div class="mt-12 p-6 bg-slate-50 rounded-2xl">
                    <div class="flex items-center gap-4">
                        <div class="w-16 h-16 rounded-full overflow-hidden bg-slate-200">
                            @if($post->author->avatar)
                                <img src="{{ $post->author->avatar }}" alt="{{ $post->author->name }}" class="w-full h-full object-cover">
                            @else
                                <div class="w-full h-full flex items-center justify-center text-slate-400">
                                    <svg class="w-8 h-8" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"/></svg>
                                </div>
                            @endif
                        </div>
                        <div>
                            <h4 class="font-bold text-slate-900">{{ $post->author->name }}</h4>
                            @if($post->author->title)
                                <p class="text-sm text-slate-600">{{ $post->author->title }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</article>

<!-- Related Posts -->
@if(isset($relatedPosts) && $relatedPosts->count() > 0)
    <section class="py-20 bg-slate-50">
        <div class="container mx-auto px-4">
            <h2 class="text-2xl font-bold text-slate-900 mb-8 text-center">
                {{ app()->getLocale() === 'ar' ? 'مقالات ذات صلة' : 'Related Articles' }}
            </h2>
            <div class="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
                @foreach($relatedPosts as $related)
                    <article class="bg-white rounded-xl overflow-hidden shadow-sm hover:shadow-lg transition-shadow">
                        <a href="{{ route('blog.show', $related->slug) }}" class="block">
                            <div class="aspect-[16/9] overflow-hidden">
                                <img src="{{ $related->featured_image ?? 'https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=600' }}" 
                                     alt="{{ $related->getTranslation('title', app()->getLocale()) }}" 
                                     class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                            </div>
                        </a>
                        <div class="p-5">
                            <span class="text-sm text-slate-500">{{ $related->published_at->format('M d, Y') }}</span>
                            <a href="{{ route('blog.show', $related->slug) }}">
                                <h3 class="font-bold text-slate-900 mt-2 hover:text-primary-600 transition-colors line-clamp-2">
                                    {{ $related->getTranslation('title', app()->getLocale()) }}
                                </h3>
                            </a>
                        </div>
                    </article>
                @endforeach
            </div>
        </div>
    </section>
@endif
@endsection
