@extends('frontend.layouts.app')

@section('title', __('messages.careers') . ' - ' . config('app.name'))
@section('meta_description', __('messages.careers_subtitle'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[45vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <span class="inline-block px-4 py-1 bg-primary-500/20 text-primary-400 text-sm font-semibold rounded-full mb-6">
                {{ app()->getLocale() === 'ar' ? 'انضم إلى فريقنا' : 'Join Our Team' }}
            </span>
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
                {{ __('messages.careers_title') }}
            </h1>
            <p class="text-xl text-slate-300 leading-relaxed">
                {{ __('messages.careers_subtitle') }}
            </p>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Why Join Us -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">
                {{ app()->getLocale() === 'ar' ? 'لماذا أيسكو' : 'Why AISCo' }}
            </span>
            <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mt-2 mb-4">
                {{ app()->getLocale() === 'ar' ? 'بناء المستقبل معاً' : 'Building the Future Together' }}
            </h2>
            <p class="text-lg text-slate-600">
                {{ app()->getLocale() === 'ar' ? 'انضم إلى فريق يشكل مستقبل التصنيع في المملكة العربية السعودية' : 'Join a team that\'s shaping the future of manufacturing in Saudi Arabia' }}
            </p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="text-center p-6 bg-slate-50 rounded-2xl">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mx-auto mb-4">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-slate-900 mb-2">
                    {{ app()->getLocale() === 'ar' ? 'النمو الوظيفي' : 'Career Growth' }}
                </h3>
                <p class="text-slate-600 text-sm">
                    {{ app()->getLocale() === 'ar' ? 'فرص للتطور والترقي داخل الشركة' : 'Opportunities for advancement and development' }}
                </p>
            </div>
            
            <div class="text-center p-6 bg-slate-50 rounded-2xl">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mx-auto mb-4">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-slate-900 mb-2">
                    {{ app()->getLocale() === 'ar' ? 'التدريب المستمر' : 'Continuous Training' }}
                </h3>
                <p class="text-slate-600 text-sm">
                    {{ app()->getLocale() === 'ar' ? 'برامج تدريب متقدمة على أحدث التقنيات' : 'Advanced training programs on latest technologies' }}
                </p>
            </div>
            
            <div class="text-center p-6 bg-slate-50 rounded-2xl">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mx-auto mb-4">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-slate-900 mb-2">
                    {{ app()->getLocale() === 'ar' ? 'بيئة عمل محفزة' : 'Great Work Culture' }}
                </h3>
                <p class="text-slate-600 text-sm">
                    {{ app()->getLocale() === 'ar' ? 'فريق متنوع ومتعاون في بيئة مهنية' : 'Diverse and collaborative professional environment' }}
                </p>
            </div>
            
            <div class="text-center p-6 bg-slate-50 rounded-2xl">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mx-auto mb-4">
                    <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-slate-900 mb-2">
                    {{ app()->getLocale() === 'ar' ? 'مزايا تنافسية' : 'Competitive Benefits' }}
                </h3>
                <p class="text-slate-600 text-sm">
                    {{ app()->getLocale() === 'ar' ? 'رواتب ومزايا تنافسية في السوق' : 'Competitive salaries and market benefits' }}
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Open Positions -->
<section class="py-20 bg-slate-50">
    <div class="container mx-auto px-4">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mb-4">{{ __('messages.open_positions') }}</h2>
        </div>
        
        @if(isset($jobs) && $jobs->count() > 0)
            <div class="max-w-4xl mx-auto space-y-4">
                @foreach($jobs as $job)
                    <div class="bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow">
                        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                            <div>
                                <h3 class="text-xl font-bold text-slate-900 mb-2">
                                    {{ $job->getTranslation('title', app()->getLocale()) }}
                                </h3>
                                <div class="flex flex-wrap items-center gap-3 text-sm text-slate-600">
                                    <span class="flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        </svg>
                                        {{ $job->location ?? 'Jeddah' }}
                                    </span>
                                    <span class="flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                        </svg>
                                        {{ $job->type ?? 'Full-time' }}
                                    </span>
                                    @if($job->department)
                                        <span class="bg-primary-100 text-primary-700 px-2 py-0.5 rounded-full text-xs font-medium">
                                            {{ $job->department }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <a href="{{ route('careers.show', $job->slug) }}" class="inline-flex items-center justify-center px-6 py-2 bg-primary-600 text-white font-semibold rounded-lg hover:bg-primary-700 transition-colors">
                                {{ __('messages.apply_now') }}
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-16 bg-white rounded-2xl max-w-2xl mx-auto">
                <svg class="w-16 h-16 text-slate-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                </svg>
                <h3 class="text-xl font-semibold text-slate-900 mb-2">{{ __('messages.no_openings') }}</h3>
                <p class="text-slate-600 mb-6">
                    {{ app()->getLocale() === 'ar' ? 'يمكنك إرسال سيرتك الذاتية للنظر فيها مستقبلاً' : 'You can still send us your CV for future consideration' }}
                </p>
                <a href="{{ route('contact') }}" class="inline-flex items-center gap-2 text-primary-600 font-semibold hover:text-primary-700">
                    {{ __('messages.contact_us') }}
                    <svg class="w-4 h-4 {{ app()->getLocale() === 'ar' ? 'rotate-180' : '' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                    </svg>
                </a>
            </div>
        @endif
    </div>
</section>
@endsection
