@extends('frontend.layouts.app')

@section('title', ($job->getTranslation('title', app()->getLocale()) ?? __('messages.careers')) . ' - ' . config('app.name'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[40vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <nav class="mb-6">
                <ol class="flex items-center justify-center gap-2 text-sm text-slate-400">
                    <li><a href="{{ route('home') }}" class="hover:text-white">{{ __('messages.home') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li><a href="{{ route('careers.index') }}" class="hover:text-white">{{ __('messages.careers') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li class="text-primary-400">{{ $job->getTranslation('title', app()->getLocale()) }}</li>
                </ol>
            </nav>
            <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold text-white mb-6">
                {{ $job->getTranslation('title', app()->getLocale()) }}
            </h1>
            <div class="flex flex-wrap items-center justify-center gap-4 text-slate-300">
                <span class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    {{ $job->location ?? 'Jeddah, Saudi Arabia' }}
                </span>
                <span class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                    {{ $job->type ?? 'Full-time' }}
                </span>
                @if($job->department)
                    <span class="bg-primary-500/20 text-primary-300 px-3 py-1 rounded-full text-sm">
                        {{ $job->department }}
                    </span>
                @endif
            </div>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Job Details & Application -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-5xl mx-auto">
            <div class="grid lg:grid-cols-3 gap-12">
                <!-- Job Description -->
                <div class="lg:col-span-2 space-y-8">
                    <!-- Description -->
                    @if($job->getTranslation('description', app()->getLocale()))
                        <div>
                            <h2 class="text-xl font-bold text-slate-900 mb-4">{{ __('messages.job_details') }}</h2>
                            <div class="prose prose-lg max-w-none prose-p:text-slate-600">
                                {!! $job->getTranslation('description', app()->getLocale()) !!}
                            </div>
                        </div>
                    @endif
                    
                    <!-- Responsibilities -->
                    @if($job->responsibilities && count($job->responsibilities) > 0)
                        <div>
                            <h2 class="text-xl font-bold text-slate-900 mb-4">{{ __('messages.responsibilities') }}</h2>
                            <ul class="space-y-3">
                                @foreach($job->responsibilities as $item)
                                    <li class="flex items-start gap-3">
                                        <svg class="w-5 h-5 text-primary-600 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                        <span class="text-slate-600">{{ $item }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <!-- Requirements -->
                    @if($job->requirements && count($job->requirements) > 0)
                        <div>
                            <h2 class="text-xl font-bold text-slate-900 mb-4">{{ __('messages.requirements') }}</h2>
                            <ul class="space-y-3">
                                @foreach($job->requirements as $item)
                                    <li class="flex items-start gap-3">
                                        <svg class="w-5 h-5 text-primary-600 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        <span class="text-slate-600">{{ $item }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                </div>
                
                <!-- Application Form -->
                <div class="lg:col-span-1">
                    <div class="bg-slate-50 rounded-2xl p-6 sticky top-24">
                        <h3 class="text-lg font-bold text-slate-900 mb-6">{{ __('messages.apply_now') }}</h3>
                        
                        @if(session('success'))
                            <div class="mb-6 p-4 bg-green-100 text-green-800 rounded-lg">
                                {{ session('success') }}
                            </div>
                        @endif
                        
                        @if($errors->any())
                            <div class="mb-6 p-4 bg-red-100 text-red-800 rounded-lg">
                                <ul class="list-disc list-inside text-sm">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form action="{{ route('careers.apply', $job->slug) }}" method="POST" enctype="multipart/form-data" class="space-y-4">
                            @csrf
                            
                            <!-- Honeypot -->
                            <div class="hidden">
                                <input type="text" name="website" value="">
                            </div>
                            
                            <div>
                                <label for="name" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.your_name') }} *</label>
                                <input type="text" id="name" name="name" value="{{ old('name') }}" required
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors text-sm">
                            </div>
                            
                            <div>
                                <label for="email" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.your_email') }} *</label>
                                <input type="email" id="email" name="email" value="{{ old('email') }}" required
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors text-sm">
                            </div>
                            
                            <div>
                                <label for="phone" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.your_phone') }} *</label>
                                <input type="tel" id="phone" name="phone" value="{{ old('phone') }}" required
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors text-sm">
                            </div>
                            
                            <div>
                                <label for="cv" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.upload_cv') }} *</label>
                                <input type="file" id="cv" name="cv" required accept=".pdf,.doc,.docx"
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors text-sm file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:text-sm file:bg-primary-50 file:text-primary-700">
                                <p class="text-xs text-slate-500 mt-1">PDF, DOC, DOCX ({{ app()->getLocale() === 'ar' ? 'الحد الأقصى 5 ميجابايت' : 'Max 5MB' }})</p>
                            </div>
                            
                            <div>
                                <label for="cover_letter" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.cover_letter') }}</label>
                                <textarea id="cover_letter" name="cover_letter" rows="4"
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors text-sm"
                                    placeholder="{{ app()->getLocale() === 'ar' ? 'أخبرنا لماذا أنت مهتم بهذا المنصب...' : 'Tell us why you are interested in this position...' }}">{{ old('cover_letter') }}</textarea>
                            </div>
                            
                            <button type="submit" class="w-full px-6 py-3 bg-primary-600 text-white font-semibold rounded-lg hover:bg-primary-700 transition-colors">
                                {{ __('messages.apply_now') }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Other Jobs -->
@if(isset($otherJobs) && $otherJobs->count() > 0)
    <section class="py-20 bg-slate-50">
        <div class="container mx-auto px-4">
            <h2 class="text-2xl font-bold text-slate-900 mb-8 text-center">
                {{ app()->getLocale() === 'ar' ? 'وظائف أخرى' : 'Other Openings' }}
            </h2>
            <div class="max-w-3xl mx-auto space-y-4">
                @foreach($otherJobs as $otherJob)
                    <a href="{{ route('careers.show', $otherJob->slug) }}" class="block bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="font-bold text-slate-900">{{ $otherJob->getTranslation('title', app()->getLocale()) }}</h3>
                                <div class="flex items-center gap-3 text-sm text-slate-500 mt-1">
                                    <span>{{ $otherJob->location ?? 'Jeddah' }}</span>
                                    <span>•</span>
                                    <span>{{ $otherJob->type ?? 'Full-time' }}</span>
                                </div>
                            </div>
                            <svg class="w-5 h-5 text-slate-400 {{ app()->getLocale() === 'ar' ? 'rotate-180' : '' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
    </section>
@endif
@endsection
