@extends('frontend.layouts.app')

@section('title', 'Precision CNC Factory')
@section('meta_description', 'Advanced Industrial Services Co - PRECISION CNC FACTORY. Igniting sparks to start real manufacturing in KSA. CNC Manufacturing, Pattern Making, Reverse Engineering.')

@section('content')
    <!-- Hero Section -->
    <section class="relative min-h-[90vh] flex items-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
        <!-- Background Pattern -->
        <div class="absolute inset-0 opacity-10">
            <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
        </div>

        <!-- Animated Gears Background -->
        <div class="absolute right-0 top-0 w-1/2 h-full opacity-20">
            <svg class="absolute -right-20 -top-20 w-96 h-96 text-primary-500 animate-spin-slow" viewBox="0 0 100 100" fill="currentColor">
                <path d="M50 10c-1.7 0-3.4.1-5 .3V5h-5v6.5c-3.3.8-6.4 2-9.3 3.6l-4.6-4.6-3.5 3.5 4.6 4.6c-1.6 2.9-2.8 6-3.6 9.3H17v5h6.3c-.2 1.6-.3 3.3-.3 5s.1 3.4.3 5H17v5h6.5c.8 3.3 2 6.4 3.6 9.3l-4.6 4.6 3.5 3.5 4.6-4.6c2.9 1.6 6 2.8 9.3 3.6V95h5v-6.3c1.6.2 3.3.3 5 .3s3.4-.1 5-.3V95h5v-6.5c3.3-.8 6.4-2 9.3-3.6l4.6 4.6 3.5-3.5-4.6-4.6c1.6-2.9 2.8-6 3.6-9.3H83v-5h-6.3c.2-1.6.3-3.3.3-5s-.1-3.4-.3-5H83v-5h-6.5c-.8-3.3-2-6.4-3.6-9.3l4.6-4.6-3.5-3.5-4.6 4.6c-2.9-1.6-6-2.8-9.3-3.6V5h-5v5.3c-1.6-.2-3.3-.3-5-.3zm0 20c11 0 20 9 20 20s-9 20-20 20-20-9-20-20 9-20 20-20z"/>
            </svg>
        </div>

        <div class="container mx-auto px-4 relative z-10">
            <div class="max-w-4xl">
                <div class="inline-flex items-center gap-2 bg-primary-500/20 text-primary-400 px-4 py-2 rounded-full text-sm font-medium mb-6 animate-fade-in">
                    <span class="w-2 h-2 bg-primary-400 rounded-full animate-pulse"></span>
                    Advanced Industrial Services Co
                </div>
                <h1 class="text-5xl md:text-7xl font-bold text-white mb-6 leading-tight animate-slide-up">
                    PRECISION CNC<br>
                    <span class="text-transparent bg-clip-text bg-gradient-to-r from-primary-400 to-cyan-400">FACTORY</span>
                </h1>
                <p class="text-xl md:text-2xl text-slate-300 mb-8 max-w-2xl animate-slide-up animation-delay-100">
                    Igniting sparks to start real manufacturing in KSA
                </p>
                <p class="text-lg text-slate-400 mb-10 max-w-2xl animate-slide-up animation-delay-200">
                    Superior levels of versatility, efficiency, and precision. From aerospace to medical devices, 
                    we deliver certified components with fast manufacturing times.
                </p>
                <div class="flex flex-wrap gap-4 animate-slide-up animation-delay-300">
                    <a href="{{ route('quote') }}" class="btn-primary btn-lg group">
                        <span>Request a Quote</span>
                        <svg class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                    <a href="{{ route('services.index') }}" class="btn-secondary btn-lg">
                        <span>Our Services</span>
                    </a>
                </div>

                <!-- Stats Row -->
                <div class="grid grid-cols-3 gap-8 mt-16 pt-8 border-t border-white/10">
                    <div class="animate-fade-in animation-delay-400">
                        <div class="text-3xl md:text-4xl font-bold text-white">69%</div>
                        <div class="text-slate-400 text-sm mt-1">Cost Savings</div>
                    </div>
                    <div class="animate-fade-in animation-delay-500">
                        <div class="text-3xl md:text-4xl font-bold text-white">4 Weeks</div>
                        <div class="text-slate-400 text-sm mt-1">Rapid Delivery</div>
                    </div>
                    <div class="animate-fade-in animation-delay-600">
                        <div class="text-3xl md:text-4xl font-bold text-white">9+</div>
                        <div class="text-slate-400 text-sm mt-1">Industries Served</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Scroll Indicator -->
        <div class="absolute bottom-8 left-1/2 -translate-x-1/2 animate-bounce">
            <svg class="w-6 h-6 text-white/50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"/>
            </svg>
        </div>
    </section>

    <!-- Value Proposition Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center max-w-3xl mx-auto mb-16">
                <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">Why Choose Us</span>
                <h2 class="text-4xl font-bold text-slate-900 mt-3 mb-6">Real Manufacturing Solutions in KSA</h2>
                <p class="text-lg text-slate-600">
                    Reduce lead times from months to weeks. Save up to 69% on costs while getting certified, 
                    precision-machined parts delivered locally.
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <!-- Feature Card 1 -->
                <div class="group bg-slate-50 rounded-2xl p-8 hover:bg-primary-600 hover:shadow-xl transition-all duration-300">
                    <div class="w-14 h-14 bg-primary-100 group-hover:bg-white/20 rounded-xl flex items-center justify-center mb-6 transition-colors">
                        <svg class="w-7 h-7 text-primary-600 group-hover:text-white transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 group-hover:text-white mb-3 transition-colors">Rapid Manufacturing</h3>
                    <p class="text-slate-600 group-hover:text-white/80 transition-colors">
                        Parts delivered in 4 weeks instead of 6-9 months. Local production means faster turnaround and no shipping delays.
                    </p>
                </div>

                <!-- Feature Card 2 -->
                <div class="group bg-slate-50 rounded-2xl p-8 hover:bg-primary-600 hover:shadow-xl transition-all duration-300">
                    <div class="w-14 h-14 bg-primary-100 group-hover:bg-white/20 rounded-xl flex items-center justify-center mb-6 transition-colors">
                        <svg class="w-7 h-7 text-primary-600 group-hover:text-white transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 group-hover:text-white mb-3 transition-colors">Certified Quality</h3>
                    <p class="text-slate-600 group-hover:text-white/80 transition-colors">
                        All parts are certified to meet exact specifications. Military-grade precision for aerospace, medical, and industrial applications.
                    </p>
                </div>

                <!-- Feature Card 3 -->
                <div class="group bg-slate-50 rounded-2xl p-8 hover:bg-primary-600 hover:shadow-xl transition-all duration-300">
                    <div class="w-14 h-14 bg-primary-100 group-hover:bg-white/20 rounded-xl flex items-center justify-center mb-6 transition-colors">
                        <svg class="w-7 h-7 text-primary-600 group-hover:text-white transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 group-hover:text-white mb-3 transition-colors">Cost Effective</h3>
                    <p class="text-slate-600 group-hover:text-white/80 transition-colors">
                        Save up to 69% compared to importing parts. Example: $28,600 vs $92,700 for helicopter rotary assembly parts.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="py-20 bg-slate-50">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row md:items-end md:justify-between mb-12">
                <div>
                    <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">Our Services</span>
                    <h2 class="text-4xl font-bold text-slate-900 mt-3">What We Offer</h2>
                </div>
                <a href="{{ route('services.index') }}" class="text-primary-600 font-semibold hover:text-primary-700 inline-flex items-center gap-2 mt-4 md:mt-0">
                    View All Services
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                    </svg>
                </a>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <!-- CNC Manufacturing -->
                <div class="bg-white rounded-2xl overflow-hidden shadow-sm hover:shadow-xl transition-shadow group">
                    <div class="aspect-video bg-gradient-to-br from-slate-800 to-slate-900 relative overflow-hidden">
                        <div class="absolute inset-0 bg-[url('/images/cnc-machining.jpg')] bg-cover bg-center opacity-60 group-hover:scale-105 transition-transform duration-500"></div>
                        <div class="absolute inset-0 flex items-center justify-center">
                            <div class="w-16 h-16 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-3">CNC Manufacturing</h3>
                        <p class="text-slate-600 mb-4">
                            Subtractive and additive manufacturing with precision turning, milling, drilling, EDM, and grinding processes.
                        </p>
                        <a href="{{ route('services.show', 'cnc-manufacturing') }}" class="text-primary-600 font-semibold hover:text-primary-700 inline-flex items-center gap-2">
                            Learn More
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Pattern Making -->
                <div class="bg-white rounded-2xl overflow-hidden shadow-sm hover:shadow-xl transition-shadow group">
                    <div class="aspect-video bg-gradient-to-br from-amber-700 to-amber-900 relative overflow-hidden">
                        <div class="absolute inset-0 bg-[url('/images/pattern-making.jpg')] bg-cover bg-center opacity-60 group-hover:scale-105 transition-transform duration-500"></div>
                        <div class="absolute inset-0 flex items-center justify-center">
                            <div class="w-16 h-16 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-3">Pattern Making</h3>
                        <p class="text-slate-600 mb-4">
                            Sand casting foundry collaboration with CNC wood/urethane patterns, 3D-printed molds, and expert patternmakers.
                        </p>
                        <a href="{{ route('services.show', 'pattern-making') }}" class="text-primary-600 font-semibold hover:text-primary-700 inline-flex items-center gap-2">
                            Learn More
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Reverse Engineering -->
                <div class="bg-white rounded-2xl overflow-hidden shadow-sm hover:shadow-xl transition-shadow group">
                    <div class="aspect-video bg-gradient-to-br from-blue-700 to-blue-900 relative overflow-hidden">
                        <div class="absolute inset-0 bg-[url('/images/reverse-engineering.jpg')] bg-cover bg-center opacity-60 group-hover:scale-105 transition-transform duration-500"></div>
                        <div class="absolute inset-0 flex items-center justify-center">
                            <div class="w-16 h-16 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center">
                                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-900 mb-3">Reverse Engineering</h3>
                        <p class="text-slate-600 mb-4">
                            Deconstructing and duplicating parts with 100% accuracy using advanced 3D scanning and CAD technology.
                        </p>
                        <a href="{{ route('services.show', 'reverse-engineering') }}" class="text-primary-600 font-semibold hover:text-primary-700 inline-flex items-center gap-2">
                            Learn More
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Industries Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center max-w-3xl mx-auto mb-12">
                <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">Industries We Serve</span>
                <h2 class="text-4xl font-bold text-slate-900 mt-3 mb-6">Precision Machining Across Industries</h2>
                <p class="text-lg text-slate-600">
                    Producing components with fast manufacturing times and repeatable accuracy for the most demanding industries.
                </p>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                @foreach([
                    ['name' => 'Aircrafts', 'icon' => 'M12 19l9 2-9-18-9 18 9-2zm0 0v-8', 'color' => 'from-blue-600 to-blue-800'],
                    ['name' => 'Military', 'icon' => 'M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z', 'color' => 'from-slate-700 to-slate-900'],
                    ['name' => 'Aerospace', 'icon' => 'M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4', 'color' => 'from-indigo-600 to-indigo-800'],
                    ['name' => 'Medical Devices', 'icon' => 'M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z', 'color' => 'from-red-500 to-red-700'],
                    ['name' => 'Optical Equipment', 'icon' => 'M15 12a3 3 0 11-6 0 3 3 0 016 0z M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z', 'color' => 'from-purple-600 to-purple-800'],
                    ['name' => 'Pattern Making', 'icon' => 'M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10', 'color' => 'from-amber-600 to-amber-800'],
                    ['name' => 'Pharmaceuticals', 'icon' => 'M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z', 'color' => 'from-teal-600 to-teal-800'],
                    ['name' => 'General Spare Parts', 'icon' => 'M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z M15 12a3 3 0 11-6 0 3 3 0 016 0z', 'color' => 'from-gray-600 to-gray-800'],
                    ['name' => 'Oil & Gas', 'icon' => 'M17.657 18.657A8 8 0 016.343 7.343S7 9 9 10c0-2 .5-5 2.986-7C14 5 16.09 5.777 17.656 7.343A7.975 7.975 0 0120 13a7.975 7.975 0 01-2.343 5.657z M9.879 16.121A3 3 0 1012.015 11L11 14H9c0 .768.293 1.536.879 2.121z', 'color' => 'from-orange-600 to-orange-800'],
                ] as $industry)
                <a href="{{ route('industries.show', Str::slug($industry['name'])) }}" class="group relative aspect-[4/3] rounded-2xl overflow-hidden">
                    <div class="absolute inset-0 bg-gradient-to-br {{ $industry['color'] }}"></div>
                    <div class="absolute inset-0 bg-black/20 group-hover:bg-black/10 transition-colors"></div>
                    <div class="absolute inset-0 flex flex-col items-center justify-center p-4 text-center">
                        <svg class="w-10 h-10 text-white/80 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="{{ $industry['icon'] }}"/>
                        </svg>
                        <span class="text-white font-semibold">{{ $industry['name'] }}</span>
                    </div>
                    <div class="absolute inset-0 border-2 border-white/0 group-hover:border-white/20 rounded-2xl transition-colors"></div>
                </a>
                @endforeach
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-20 bg-gradient-to-br from-primary-600 to-primary-800 relative overflow-hidden">
        <div class="absolute inset-0 opacity-10">
            <svg class="absolute right-0 top-0 h-full w-auto" viewBox="0 0 100 100" fill="currentColor">
                <circle cx="80" cy="20" r="60" class="text-white"/>
            </svg>
        </div>
        <div class="container mx-auto px-4 relative z-10">
            <div class="max-w-4xl mx-auto text-center">
                <h2 class="text-4xl md:text-5xl font-bold text-white mb-6">
                    Ready to Reduce Your Lead Time by 80%?
                </h2>
                <p class="text-xl text-white/80 mb-10 max-w-2xl mx-auto">
                    Get your precision parts manufactured locally in KSA. Request a quote today and receive certified components in as little as 4 weeks.
                </p>
                <div class="flex flex-wrap justify-center gap-4">
                    <a href="{{ route('quote') }}" class="bg-white text-primary-600 px-8 py-4 rounded-xl font-semibold hover:bg-slate-100 transition-colors inline-flex items-center gap-2">
                        <span>Request a Quote</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                    <a href="{{ route('contact') }}" class="bg-transparent border-2 border-white text-white px-8 py-4 rounded-xl font-semibold hover:bg-white/10 transition-colors">
                        Contact Us
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Partners Section -->
    @if($partners->count() > 0)
    <section class="py-16 bg-slate-50">
        <div class="container mx-auto px-4">
            <div class="text-center mb-10">
                <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">Trusted By</span>
                <h2 class="text-2xl font-bold text-slate-900 mt-2">Our Partners & Clients</h2>
            </div>
            <div class="flex flex-wrap justify-center items-center gap-12">
                @foreach($partners as $partner)
                <div class="grayscale hover:grayscale-0 opacity-60 hover:opacity-100 transition-all">
                    <img src="{{ Storage::url($partner->logo) }}" alt="{{ $partner->name }}" class="h-12 w-auto">
                </div>
                @endforeach
            </div>
        </div>
    </section>
    @endif
@endsection

@push('styles')
<style>
    @keyframes spin-slow {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
    .animate-spin-slow {
        animation: spin-slow 30s linear infinite;
    }
    @keyframes fade-in {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    .animate-fade-in {
        animation: fade-in 0.6s ease-out forwards;
    }
    @keyframes slide-up {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .animate-slide-up {
        animation: slide-up 0.6s ease-out forwards;
    }
    .animation-delay-100 { animation-delay: 0.1s; opacity: 0; }
    .animation-delay-200 { animation-delay: 0.2s; opacity: 0; }
    .animation-delay-300 { animation-delay: 0.3s; opacity: 0; }
    .animation-delay-400 { animation-delay: 0.4s; opacity: 0; }
    .animation-delay-500 { animation-delay: 0.5s; opacity: 0; }
    .animation-delay-600 { animation-delay: 0.6s; opacity: 0; }
</style>
@endpush
