@extends('frontend.layouts.app')

@section('title', __('messages.industries') . ' - ' . config('app.name'))
@section('meta_description', __('messages.industries_subtitle'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[40vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <span class="inline-block px-4 py-1 bg-primary-500/20 text-primary-400 text-sm font-semibold rounded-full mb-6">
                {{ __('messages.industries') }}
            </span>
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
                {{ __('messages.industries_we_serve') }}
            </h1>
            <p class="text-xl text-slate-300 leading-relaxed">
                {{ __('messages.industries_subtitle') }}
            </p>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Industries Grid -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Aircraft -->
            <a href="{{ route('industries.show', 'aircrafts') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/aircraft.jpg') }}" alt="{{ __('messages.aircrafts') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1474302770737-173ee21bab63?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.aircrafts') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.aircrafts_desc') }}</p>
                </div>
            </a>
            
            <!-- Military -->
            <a href="{{ route('industries.show', 'military') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/military.jpg') }}" alt="{{ __('messages.military') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1580752300992-559f8e0734e0?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.military') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.military_desc') }}</p>
                </div>
            </a>
            
            <!-- Aerospace -->
            <a href="{{ route('industries.show', 'aerospace') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/aerospace.jpg') }}" alt="{{ __('messages.aerospace') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1446776811953-b23d57bd21aa?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.aerospace') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.aerospace_desc') }}</p>
                </div>
            </a>
            
            <!-- Medical Devices -->
            <a href="{{ route('industries.show', 'medical-devices') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/medical.jpg') }}" alt="{{ __('messages.medical_devices') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1559757148-5c350d0d3c56?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.medical_devices') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.medical_devices_desc') }}</p>
                </div>
            </a>
            
            <!-- Optical Equipment -->
            <a href="{{ route('industries.show', 'optical-equipment') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/optical.jpg') }}" alt="{{ __('messages.optical_equipment') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.optical_equipment') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.optical_equipment_desc') }}</p>
                </div>
            </a>
            
            <!-- Pattern Making -->
            <a href="{{ route('industries.show', 'pattern-making') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/pattern.jpg') }}" alt="{{ __('messages.pattern_making_industry') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1504917595217-d4dc5ebe6122?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.pattern_making_industry') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.pattern_making_industry_desc') }}</p>
                </div>
            </a>
            
            <!-- Pharmaceuticals -->
            <a href="{{ route('industries.show', 'pharmaceuticals') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/pharma.jpg') }}" alt="{{ __('messages.pharmaceuticals') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1471864190281-a93a3070b6de?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.pharmaceuticals') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.pharmaceuticals_desc') }}</p>
                </div>
            </a>
            
            <!-- General Spare Parts -->
            <a href="{{ route('industries.show', 'general-spare-parts') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/spare-parts.jpg') }}" alt="{{ __('messages.general_spare_parts') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1486262715619-67b85e0b08d3?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.general_spare_parts') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.general_spare_parts_desc') }}</p>
                </div>
            </a>
            
            <!-- Oil & Gas -->
            <a href="{{ route('industries.show', 'oil-gas') }}" class="group relative rounded-2xl overflow-hidden aspect-[4/3] shadow-lg">
                <img src="{{ asset('images/industries/oil-gas.jpg') }}" alt="{{ __('messages.oil_gas') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1497435334941-8c899ee9e8e9?w=600'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/50 to-transparent"></div>
                <div class="absolute bottom-0 left-0 right-0 p-6">
                    <h3 class="text-2xl font-bold text-white mb-2">{{ __('messages.oil_gas') }}</h3>
                    <p class="text-slate-300 text-sm line-clamp-2">{{ __('messages.oil_gas_desc') }}</p>
                </div>
            </a>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-700">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">{{ __('messages.ready_to_start') }}</h2>
        <p class="text-xl text-primary-100 mb-8 max-w-2xl mx-auto">{{ __('messages.cta_description') }}</p>
        <a href="{{ route('quote') }}" class="inline-flex items-center justify-center px-8 py-3 bg-white text-primary-600 font-semibold rounded-lg hover:bg-primary-50 transition-colors">
            {{ __('messages.request_quote') }}
        </a>
    </div>
</section>
@endsection
