@extends('frontend.layouts.app')

@section('title', ($industry->getTranslation('name', app()->getLocale()) ?? __('messages.industries')) . ' - ' . config('app.name'))
@section('meta_description', $industry->getTranslation('excerpt', app()->getLocale()) ?? '')

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[45vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-20">
        @if($industry->featured_image)
            <img src="{{ $industry->featured_image }}" alt="" class="w-full h-full object-cover">
        @endif
    </div>
    <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/80 to-slate-900/60"></div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <nav class="mb-6">
                <ol class="flex items-center justify-center gap-2 text-sm text-slate-400">
                    <li><a href="{{ route('home') }}" class="hover:text-white">{{ __('messages.home') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li><a href="{{ route('industries.index') }}" class="hover:text-white">{{ __('messages.industries') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li class="text-primary-400">{{ $industry->getTranslation('name', app()->getLocale()) }}</li>
                </ol>
            </nav>
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
                {{ $industry->getTranslation('name', app()->getLocale()) }}
            </h1>
            @if($industry->getTranslation('excerpt', app()->getLocale()))
                <p class="text-xl text-slate-300 leading-relaxed">
                    {{ $industry->getTranslation('excerpt', app()->getLocale()) }}
                </p>
            @endif
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Content -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            @if($industry->getTranslation('description', app()->getLocale()))
                <div class="prose prose-lg max-w-none prose-headings:text-slate-900 prose-p:text-slate-600 prose-a:text-primary-600">
                    {!! $industry->getTranslation('description', app()->getLocale()) !!}
                </div>
            @endif
            
            <!-- Capabilities -->
            @if($industry->capabilities && count($industry->capabilities) > 0)
                <div class="mt-12 bg-slate-50 rounded-2xl p-8">
                    <h2 class="text-2xl font-bold text-slate-900 mb-6">
                        {{ app()->getLocale() === 'ar' ? 'قدراتنا' : 'Our Capabilities' }}
                    </h2>
                    <div class="grid md:grid-cols-2 gap-4">
                        @foreach($industry->capabilities as $capability)
                            <div class="flex items-start gap-3">
                                <svg class="w-5 h-5 text-primary-600 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                                <span class="text-slate-700">{{ $capability }}</span>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</section>

<!-- Related Projects -->
@if(isset($projects) && $projects->count() > 0)
    <section class="py-20 bg-slate-50">
        <div class="container mx-auto px-4">
            <h2 class="text-2xl font-bold text-slate-900 mb-8 text-center">
                {{ app()->getLocale() === 'ar' ? 'مشاريع ذات صلة' : 'Related Projects' }}
            </h2>
            <div class="grid md:grid-cols-3 gap-8">
                @foreach($projects as $project)
                    <a href="{{ route('projects.show', $project->slug) }}" class="group">
                        <div class="relative aspect-[4/3] rounded-xl overflow-hidden shadow-lg">
                            <img src="{{ $project->featured_image ?? 'https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=600' }}" 
                                 alt="{{ $project->getTranslation('title', app()->getLocale()) }}" 
                                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                            <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 to-transparent"></div>
                            <div class="absolute bottom-0 left-0 right-0 p-6">
                                <h3 class="text-lg font-bold text-white group-hover:text-primary-300 transition-colors">
                                    {{ $project->getTranslation('title', app()->getLocale()) }}
                                </h3>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
            <div class="text-center mt-8">
                <a href="{{ route('projects.index') }}" class="inline-flex items-center gap-2 text-primary-600 font-semibold hover:text-primary-700">
                    {{ __('messages.view_all') }} {{ __('messages.projects') }}
                    <svg class="w-4 h-4 {{ app()->getLocale() === 'ar' ? 'rotate-180' : '' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                    </svg>
                </a>
            </div>
        </div>
    </section>
@endif

<!-- Other Industries -->
@if(isset($otherIndustries) && $otherIndustries->count() > 0)
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <h2 class="text-2xl font-bold text-slate-900 mb-8 text-center">
                {{ app()->getLocale() === 'ar' ? 'صناعات أخرى' : 'Other Industries' }}
            </h2>
            <div class="grid md:grid-cols-4 gap-6 max-w-5xl mx-auto">
                @foreach($otherIndustries as $other)
                    <a href="{{ route('industries.show', $other->slug) }}" class="group p-4 bg-slate-50 rounded-xl text-center hover:bg-primary-50 transition-colors">
                        @if($other->icon)
                            <div class="w-12 h-12 bg-white rounded-lg flex items-center justify-center mx-auto mb-3 shadow-sm">
                                {!! $other->icon !!}
                            </div>
                        @endif
                        <h3 class="font-semibold text-slate-900 group-hover:text-primary-600 transition-colors">
                            {{ $other->getTranslation('name', app()->getLocale()) }}
                        </h3>
                    </a>
                @endforeach
            </div>
        </div>
    </section>
@endif

<!-- CTA Section -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-700">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">{{ __('messages.ready_to_start') }}</h2>
        <p class="text-xl text-primary-100 mb-8 max-w-2xl mx-auto">{{ __('messages.cta_description') }}</p>
        <a href="{{ route('quote') }}" class="inline-flex items-center justify-center px-8 py-3 bg-white text-primary-600 font-semibold rounded-lg hover:bg-primary-50 transition-colors">
            {{ __('messages.request_quote') }}
        </a>
    </div>
</section>
@endsection
