@extends('frontend.layouts.app')

@section('title', __('messages.projects') . ' - ' . config('app.name'))
@section('meta_description', __('messages.projects_subtitle'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[40vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <span class="inline-block px-4 py-1 bg-primary-500/20 text-primary-400 text-sm font-semibold rounded-full mb-6">
                {{ __('messages.portfolio') }}
            </span>
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
                {{ __('messages.our_projects') }}
            </h1>
            <p class="text-xl text-slate-300 leading-relaxed">
                {{ __('messages.projects_subtitle') }}
            </p>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Filter Section -->
<section class="py-8 bg-white border-b border-slate-100">
    <div class="container mx-auto px-4">
        <div class="flex flex-wrap items-center justify-center gap-3">
            <a href="{{ route('projects.index') }}" 
               class="px-5 py-2 rounded-full font-medium transition-all {{ !request('category') ? 'bg-primary-600 text-white' : 'bg-slate-100 text-slate-700 hover:bg-slate-200' }}">
                {{ __('messages.all_categories') }}
            </a>
            @if(isset($categories))
                @foreach($categories as $category)
                    <a href="{{ route('projects.index', ['category' => $category->slug]) }}" 
                       class="px-5 py-2 rounded-full font-medium transition-all {{ request('category') == $category->slug ? 'bg-primary-600 text-white' : 'bg-slate-100 text-slate-700 hover:bg-slate-200' }}">
                        {{ $category->getTranslation('name', app()->getLocale()) }}
                    </a>
                @endforeach
            @endif
        </div>
    </div>
</section>

<!-- Projects Grid -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        @if(isset($projects) && $projects->count() > 0)
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach($projects as $project)
                    <a href="{{ route('projects.show', $project->slug) }}" class="group">
                        <div class="relative aspect-[4/3] rounded-2xl overflow-hidden shadow-lg">
                            <img src="{{ $project->featured_image ?? 'https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=600' }}" 
                                 alt="{{ $project->getTranslation('title', app()->getLocale()) }}" 
                                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                            <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-slate-900/30 to-transparent opacity-80 group-hover:opacity-90 transition-opacity"></div>
                            <div class="absolute bottom-0 left-0 right-0 p-6">
                                @if($project->category)
                                    <span class="inline-block px-3 py-1 bg-primary-500/80 text-white text-xs font-semibold rounded-full mb-3">
                                        {{ $project->category->getTranslation('name', app()->getLocale()) }}
                                    </span>
                                @endif
                                <h3 class="text-xl font-bold text-white mb-2 group-hover:text-primary-300 transition-colors">
                                    {{ $project->getTranslation('title', app()->getLocale()) }}
                                </h3>
                                <p class="text-slate-300 text-sm line-clamp-2">
                                    {{ $project->getTranslation('excerpt', app()->getLocale()) }}
                                </p>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
            
            <!-- Pagination -->
            @if($projects->hasPages())
                <div class="mt-12 flex justify-center">
                    {{ $projects->links() }}
                </div>
            @endif
        @else
            <!-- Empty State -->
            <div class="text-center py-16">
                <svg class="w-16 h-16 text-slate-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                </svg>
                <h3 class="text-xl font-semibold text-slate-900 mb-2">
                    {{ app()->getLocale() === 'ar' ? 'لا توجد مشاريع حالياً' : 'No projects yet' }}
                </h3>
                <p class="text-slate-600">
                    {{ app()->getLocale() === 'ar' ? 'سيتم إضافة مشاريعنا قريباً' : 'Our projects will be added soon' }}
                </p>
            </div>
        @endif
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-700">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">{{ __('messages.ready_to_start') }}</h2>
        <p class="text-xl text-primary-100 mb-8 max-w-2xl mx-auto">{{ __('messages.cta_description') }}</p>
        <a href="{{ route('quote') }}" class="inline-flex items-center justify-center px-8 py-3 bg-white text-primary-600 font-semibold rounded-lg hover:bg-primary-50 transition-colors">
            {{ __('messages.request_quote') }}
        </a>
    </div>
</section>
@endsection
