@extends('frontend.layouts.app')

@section('title', ($project->getTranslation('title', app()->getLocale()) ?? __('messages.projects')) . ' - ' . config('app.name'))
@section('meta_description', $project->getTranslation('excerpt', app()->getLocale()) ?? '')

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[50vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-30">
        @if($project->featured_image)
            <img src="{{ $project->featured_image }}" alt="" class="w-full h-full object-cover">
        @endif
    </div>
    <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/70 to-slate-900/50"></div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <nav class="mb-6">
                <ol class="flex items-center justify-center gap-2 text-sm text-slate-400">
                    <li><a href="{{ route('home') }}" class="hover:text-white">{{ __('messages.home') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li><a href="{{ route('projects.index') }}" class="hover:text-white">{{ __('messages.projects') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li class="text-primary-400">{{ $project->getTranslation('title', app()->getLocale()) }}</li>
                </ol>
            </nav>
            @if($project->category)
                <span class="inline-block px-4 py-1 bg-primary-500/20 text-primary-400 text-sm font-semibold rounded-full mb-6">
                    {{ $project->category->getTranslation('name', app()->getLocale()) }}
                </span>
            @endif
            <h1 class="text-4xl md:text-5xl font-bold text-white mb-6">
                {{ $project->getTranslation('title', app()->getLocale()) }}
            </h1>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Project Details -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-5xl mx-auto">
            <div class="grid lg:grid-cols-3 gap-12">
                <!-- Main Content -->
                <div class="lg:col-span-2">
                    @if($project->getTranslation('description', app()->getLocale()))
                        <div class="prose prose-lg max-w-none prose-headings:text-slate-900 prose-p:text-slate-600">
                            {!! $project->getTranslation('description', app()->getLocale()) !!}
                        </div>
                    @endif
                    
                    <!-- Gallery -->
                    @if($project->images && $project->images->count() > 0)
                        <div class="mt-12">
                            <h2 class="text-2xl font-bold text-slate-900 mb-6">{{ __('messages.project_gallery') }}</h2>
                            <div class="grid grid-cols-2 gap-4">
                                @foreach($project->images as $image)
                                    <a href="{{ $image->url }}" class="block aspect-[4/3] rounded-xl overflow-hidden group" data-lightbox="gallery">
                                        <img src="{{ $image->url }}" alt="{{ $image->alt ?? '' }}" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
                
                <!-- Sidebar -->
                <div class="lg:col-span-1">
                    <div class="bg-slate-50 rounded-2xl p-6 sticky top-24">
                        <h3 class="text-lg font-bold text-slate-900 mb-4">{{ __('messages.project_details') }}</h3>
                        <dl class="space-y-4">
                            @if($project->client)
                                <div>
                                    <dt class="text-sm text-slate-500">{{ app()->getLocale() === 'ar' ? 'العميل' : 'Client' }}</dt>
                                    <dd class="font-medium text-slate-900">{{ $project->client }}</dd>
                                </div>
                            @endif
                            @if($project->industry)
                                <div>
                                    <dt class="text-sm text-slate-500">{{ __('messages.industries') }}</dt>
                                    <dd class="font-medium text-slate-900">
                                        <a href="{{ route('industries.show', $project->industry->slug) }}" class="text-primary-600 hover:text-primary-700">
                                            {{ $project->industry->getTranslation('name', app()->getLocale()) }}
                                        </a>
                                    </dd>
                                </div>
                            @endif
                            @if($project->service)
                                <div>
                                    <dt class="text-sm text-slate-500">{{ __('messages.services') }}</dt>
                                    <dd class="font-medium text-slate-900">{{ $project->service }}</dd>
                                </div>
                            @endif
                            @if($project->material)
                                <div>
                                    <dt class="text-sm text-slate-500">{{ __('messages.materials') }}</dt>
                                    <dd class="font-medium text-slate-900">{{ $project->material }}</dd>
                                </div>
                            @endif
                            @if($project->completed_at)
                                <div>
                                    <dt class="text-sm text-slate-500">{{ app()->getLocale() === 'ar' ? 'تاريخ الإنجاز' : 'Completed' }}</dt>
                                    <dd class="font-medium text-slate-900">{{ $project->completed_at->format('F Y') }}</dd>
                                </div>
                            @endif
                        </dl>
                        
                        <div class="mt-6 pt-6 border-t border-slate-200">
                            <a href="{{ route('quote') }}" class="w-full inline-flex items-center justify-center px-6 py-3 bg-primary-600 text-white font-semibold rounded-lg hover:bg-primary-700 transition-colors">
                                {{ __('messages.request_quote') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Projects -->
@if(isset($relatedProjects) && $relatedProjects->count() > 0)
    <section class="py-20 bg-slate-50">
        <div class="container mx-auto px-4">
            <h2 class="text-2xl font-bold text-slate-900 mb-8 text-center">
                {{ app()->getLocale() === 'ar' ? 'مشاريع مشابهة' : 'Similar Projects' }}
            </h2>
            <div class="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
                @foreach($relatedProjects as $related)
                    <a href="{{ route('projects.show', $related->slug) }}" class="group">
                        <div class="relative aspect-[4/3] rounded-xl overflow-hidden shadow-lg">
                            <img src="{{ $related->featured_image ?? 'https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=600' }}" 
                                 alt="{{ $related->getTranslation('title', app()->getLocale()) }}" 
                                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                            <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 to-transparent"></div>
                            <div class="absolute bottom-0 left-0 right-0 p-6">
                                <h3 class="text-lg font-bold text-white group-hover:text-primary-300 transition-colors">
                                    {{ $related->getTranslation('title', app()->getLocale()) }}
                                </h3>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
    </section>
@endif
@endsection
