@extends('frontend.layouts.app')

@section('title', __('messages.request_quote_title') . ' - ' . config('app.name'))
@section('meta_description', __('messages.quote_subtitle'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[35vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-16">
        <div class="max-w-4xl mx-auto text-center">
            <h1 class="text-4xl md:text-5xl font-bold text-white mb-4">
                {{ __('messages.request_quote_title') }}
            </h1>
            <p class="text-xl text-slate-300">
                {{ __('messages.quote_subtitle') }}
            </p>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Quote Form Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <!-- Value Props -->
            <div class="grid md:grid-cols-3 gap-6 mb-12">
                <div class="flex items-center gap-4 p-4 bg-slate-50 rounded-xl">
                    <div class="w-12 h-12 bg-primary-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div>
                        <div class="font-semibold text-slate-900">{{ app()->getLocale() === 'ar' ? 'رد سريع' : 'Quick Response' }}</div>
                        <div class="text-sm text-slate-600">{{ app()->getLocale() === 'ar' ? 'خلال 24 ساعة' : 'Within 24 hours' }}</div>
                    </div>
                </div>
                
                <div class="flex items-center gap-4 p-4 bg-slate-50 rounded-xl">
                    <div class="w-12 h-12 bg-primary-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                    </div>
                    <div>
                        <div class="font-semibold text-slate-900">{{ app()->getLocale() === 'ar' ? 'بدون التزام' : 'No Obligation' }}</div>
                        <div class="text-sm text-slate-600">{{ app()->getLocale() === 'ar' ? 'عرض سعر مجاني' : 'Free quote' }}</div>
                    </div>
                </div>
                
                <div class="flex items-center gap-4 p-4 bg-slate-50 rounded-xl">
                    <div class="w-12 h-12 bg-primary-100 rounded-lg flex items-center justify-center flex-shrink-0">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div>
                        <div class="font-semibold text-slate-900">{{ app()->getLocale() === 'ar' ? 'توفير 69%' : '69% Savings' }}</div>
                        <div class="text-sm text-slate-600">{{ app()->getLocale() === 'ar' ? 'مقارنة بالاستيراد' : 'vs. importing' }}</div>
                    </div>
                </div>
            </div>
            
            <!-- Form -->
            <div class="bg-slate-50 rounded-2xl p-6 lg:p-10">
                @if(session('success'))
                    <div class="mb-6 p-4 bg-green-100 text-green-800 rounded-lg flex items-center gap-3">
                        <svg class="w-6 h-6 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        {{ session('success') }}
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="mb-6 p-4 bg-red-100 text-red-800 rounded-lg">
                        <ul class="list-disc list-inside">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                <form action="{{ route('quote.store') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
                    @csrf
                    
                    <!-- Honeypot -->
                    <div class="hidden">
                        <input type="text" name="website" value="">
                    </div>
                    
                    <!-- Personal Information -->
                    <div class="border-b border-slate-200 pb-6 mb-6">
                        <h3 class="text-lg font-semibold text-slate-900 mb-4">{{ app()->getLocale() === 'ar' ? 'معلومات الاتصال' : 'Contact Information' }}</h3>
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label for="name" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.your_name') }} *</label>
                                <input type="text" id="name" name="name" value="{{ old('name') }}" required
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                            </div>
                            <div>
                                <label for="email" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.your_email') }} *</label>
                                <input type="email" id="email" name="email" value="{{ old('email') }}" required
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                            </div>
                            <div>
                                <label for="phone" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.your_phone') }} *</label>
                                <input type="tel" id="phone" name="phone" value="{{ old('phone') }}" required
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                            </div>
                            <div>
                                <label for="company" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.company_name_field') }}</label>
                                <input type="text" id="company" name="company" value="{{ old('company') }}"
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Project Details -->
                    <div class="border-b border-slate-200 pb-6 mb-6">
                        <h3 class="text-lg font-semibold text-slate-900 mb-4">{{ app()->getLocale() === 'ar' ? 'تفاصيل المشروع' : 'Project Details' }}</h3>
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label for="service" class="block text-sm font-semibold text-slate-700 mb-2">{{ app()->getLocale() === 'ar' ? 'الخدمة المطلوبة' : 'Service Required' }} *</label>
                                <select id="service" name="service" required
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                                    <option value="">{{ app()->getLocale() === 'ar' ? '-- اختر الخدمة --' : '-- Select Service --' }}</option>
                                    <option value="cnc_manufacturing" {{ old('service') === 'cnc_manufacturing' ? 'selected' : '' }}>{{ __('messages.cnc_manufacturing') }}</option>
                                    <option value="pattern_making" {{ old('service') === 'pattern_making' ? 'selected' : '' }}>{{ __('messages.pattern_making') }}</option>
                                    <option value="reverse_engineering" {{ old('service') === 'reverse_engineering' ? 'selected' : '' }}>{{ __('messages.reverse_engineering') }}</option>
                                    <option value="other" {{ old('service') === 'other' ? 'selected' : '' }}>{{ app()->getLocale() === 'ar' ? 'أخرى' : 'Other' }}</option>
                                </select>
                            </div>
                            <div>
                                <label for="industry" class="block text-sm font-semibold text-slate-700 mb-2">{{ app()->getLocale() === 'ar' ? 'الصناعة' : 'Industry' }}</label>
                                <select id="industry" name="industry"
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                                    <option value="">{{ app()->getLocale() === 'ar' ? '-- اختر الصناعة --' : '-- Select Industry --' }}</option>
                                    <option value="aerospace">{{ __('messages.aerospace') }}</option>
                                    <option value="military">{{ __('messages.military') }}</option>
                                    <option value="medical">{{ __('messages.medical_devices') }}</option>
                                    <option value="oil_gas">{{ __('messages.oil_gas') }}</option>
                                    <option value="automotive">{{ __('messages.general_spare_parts') }}</option>
                                    <option value="other">{{ app()->getLocale() === 'ar' ? 'أخرى' : 'Other' }}</option>
                                </select>
                            </div>
                            <div>
                                <label for="quantity" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.quantity') }}</label>
                                <input type="text" id="quantity" name="quantity" value="{{ old('quantity') }}" placeholder="{{ app()->getLocale() === 'ar' ? 'مثال: 100 قطعة' : 'e.g., 100 units' }}"
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                            </div>
                            <div>
                                <label for="timeline" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.deadline') }}</label>
                                <select id="timeline" name="timeline"
                                    class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors">
                                    <option value="">{{ app()->getLocale() === 'ar' ? '-- اختر المدة --' : '-- Select Timeline --' }}</option>
                                    <option value="urgent">{{ app()->getLocale() === 'ar' ? 'عاجل (أقل من أسبوع)' : 'Urgent (< 1 week)' }}</option>
                                    <option value="1-2_weeks">{{ app()->getLocale() === 'ar' ? '1-2 أسابيع' : '1-2 weeks' }}</option>
                                    <option value="2-4_weeks">{{ app()->getLocale() === 'ar' ? '2-4 أسابيع' : '2-4 weeks' }}</option>
                                    <option value="1-2_months">{{ app()->getLocale() === 'ar' ? '1-2 شهر' : '1-2 months' }}</option>
                                    <option value="flexible">{{ app()->getLocale() === 'ar' ? 'مرن' : 'Flexible' }}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Requirements -->
                    <div>
                        <h3 class="text-lg font-semibold text-slate-900 mb-4">{{ __('messages.additional_details') }}</h3>
                        
                        <div class="mb-6">
                            <label for="requirements" class="block text-sm font-semibold text-slate-700 mb-2">{{ app()->getLocale() === 'ar' ? 'وصف المشروع / المتطلبات' : 'Project Description / Requirements' }} *</label>
                            <textarea id="requirements" name="requirements" rows="5" required
                                class="w-full px-4 py-3 rounded-lg border border-slate-300 focus:ring-2 focus:ring-primary-500 focus:border-primary-500 transition-colors"
                                placeholder="{{ app()->getLocale() === 'ar' ? 'يرجى وصف مشروعك، بما في ذلك المواد والأبعاد والتفاوتات وأي متطلبات خاصة...' : 'Please describe your project, including materials, dimensions, tolerances, and any special requirements...' }}">{{ old('requirements') }}</textarea>
                        </div>
                        
                        <div class="mb-6">
                            <label for="attachment" class="block text-sm font-semibold text-slate-700 mb-2">{{ __('messages.upload_files') }}</label>
                            <div class="border-2 border-dashed border-slate-300 rounded-lg p-6 text-center hover:border-primary-500 transition-colors">
                                <input type="file" id="attachment" name="attachment" class="hidden" accept=".pdf,.doc,.docx,.dwg,.dxf,.step,.stp,.igs,.iges,.stl,.jpg,.jpeg,.png">
                                <label for="attachment" class="cursor-pointer">
                                    <svg class="w-12 h-12 text-slate-400 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                                    </svg>
                                    <p class="text-slate-600 mb-1">{{ app()->getLocale() === 'ar' ? 'اضغط لرفع الملف أو اسحب وأفلت' : 'Click to upload or drag and drop' }}</p>
                                    <p class="text-sm text-slate-500">{{ __('messages.upload_files_desc') }}</p>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="w-full md:w-auto px-8 py-4 bg-primary-600 text-white font-semibold rounded-lg hover:bg-primary-700 transition-colors text-lg">
                        {{ __('messages.request_quote') }}
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection
