@extends('frontend.layouts.app')

@section('title', __('messages.services') . ' - ' . config('app.name'))
@section('meta_description', __('messages.services_subtitle'))

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[40vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'0.4\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <span class="inline-block px-4 py-1 bg-primary-500/20 text-primary-400 text-sm font-semibold rounded-full mb-6">
                {{ __('messages.our_services') }}
            </span>
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
                {{ __('messages.cnc_manufacturing') }}
            </h1>
            <p class="text-xl text-slate-300 leading-relaxed">
                {{ __('messages.services_subtitle') }}
            </p>
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Main Services -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- CNC Manufacturing -->
            <div class="group bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-300 border border-slate-100">
                <div class="aspect-[16/10] overflow-hidden">
                    <img src="{{ asset('images/services/cnc-manufacturing.jpg') }}" alt="{{ __('messages.cnc_manufacturing') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1565087918595-348c17b6ae30?w=600'">
                </div>
                <div class="p-6">
                    <div class="w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">{{ __('messages.cnc_manufacturing') }}</h3>
                    <p class="text-slate-600 mb-4">{{ __('messages.cnc_manufacturing_desc') }}</p>
                    <a href="{{ route('services.show', 'cnc-manufacturing') }}" class="inline-flex items-center gap-2 text-primary-600 font-semibold hover:text-primary-700 transition-colors">
                        {{ __('messages.learn_more') }}
                        <svg class="w-4 h-4 {{ app()->getLocale() === 'ar' ? 'rotate-180' : '' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                </div>
            </div>
            
            <!-- Pattern Making -->
            <div class="group bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-300 border border-slate-100">
                <div class="aspect-[16/10] overflow-hidden">
                    <img src="{{ asset('images/services/pattern-making.jpg') }}" alt="{{ __('messages.pattern_making') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1504917595217-d4dc5ebe6122?w=600'">
                </div>
                <div class="p-6">
                    <div class="w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 5a1 1 0 011-1h14a1 1 0 011 1v2a1 1 0 01-1 1H5a1 1 0 01-1-1V5zM4 13a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H5a1 1 0 01-1-1v-6zM16 13a1 1 0 011-1h2a1 1 0 011 1v6a1 1 0 01-1 1h-2a1 1 0 01-1-1v-6z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">{{ __('messages.pattern_making') }}</h3>
                    <p class="text-slate-600 mb-4">{{ __('messages.pattern_making_desc') }}</p>
                    <a href="{{ route('services.show', 'pattern-making') }}" class="inline-flex items-center gap-2 text-primary-600 font-semibold hover:text-primary-700 transition-colors">
                        {{ __('messages.learn_more') }}
                        <svg class="w-4 h-4 {{ app()->getLocale() === 'ar' ? 'rotate-180' : '' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                </div>
            </div>
            
            <!-- Reverse Engineering -->
            <div class="group bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-300 border border-slate-100">
                <div class="aspect-[16/10] overflow-hidden">
                    <img src="{{ asset('images/services/reverse-engineering.jpg') }}" alt="{{ __('messages.reverse_engineering') }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500" onerror="this.src='https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=600'">
                </div>
                <div class="p-6">
                    <div class="w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">{{ __('messages.reverse_engineering') }}</h3>
                    <p class="text-slate-600 mb-4">{{ __('messages.reverse_engineering_desc') }}</p>
                    <a href="{{ route('services.show', 'reverse-engineering') }}" class="inline-flex items-center gap-2 text-primary-600 font-semibold hover:text-primary-700 transition-colors">
                        {{ __('messages.learn_more') }}
                        <svg class="w-4 h-4 {{ app()->getLocale() === 'ar' ? 'rotate-180' : '' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CNC Types -->
<section class="py-20 bg-slate-50">
    <div class="container mx-auto px-4">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">{{ __('messages.cnc_processes') }}</span>
            <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mt-2">
                {{ __('messages.subtractive_manufacturing') }} & {{ __('messages.additive_manufacturing') }}
            </h2>
        </div>
        
        <div class="grid lg:grid-cols-2 gap-8">
            <!-- Subtractive -->
            <div class="bg-white rounded-2xl p-8 shadow-lg">
                <div class="flex items-center gap-4 mb-6">
                    <div class="w-14 h-14 bg-red-100 rounded-xl flex items-center justify-center">
                        <svg class="w-7 h-7 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-slate-900">{{ __('messages.subtractive_manufacturing') }}</h3>
                        <p class="text-slate-500">{{ __('messages.subtractive_desc') }}</p>
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div class="p-4 bg-slate-50 rounded-xl">
                        <h4 class="font-semibold text-slate-900 mb-1">{{ __('messages.turning') }}</h4>
                        <p class="text-sm text-slate-600">{{ __('messages.turning_desc') }}</p>
                    </div>
                    <div class="p-4 bg-slate-50 rounded-xl">
                        <h4 class="font-semibold text-slate-900 mb-1">{{ __('messages.milling') }}</h4>
                        <p class="text-sm text-slate-600">{{ __('messages.milling_desc') }}</p>
                    </div>
                    <div class="p-4 bg-slate-50 rounded-xl">
                        <h4 class="font-semibold text-slate-900 mb-1">{{ __('messages.drilling') }}</h4>
                        <p class="text-sm text-slate-600">{{ __('messages.drilling_desc') }}</p>
                    </div>
                    <div class="p-4 bg-slate-50 rounded-xl">
                        <h4 class="font-semibold text-slate-900 mb-1">{{ __('messages.grinding') }}</h4>
                        <p class="text-sm text-slate-600">{{ __('messages.grinding_desc') }}</p>
                    </div>
                </div>
            </div>
            
            <!-- Additive -->
            <div class="bg-white rounded-2xl p-8 shadow-lg">
                <div class="flex items-center gap-4 mb-6">
                    <div class="w-14 h-14 bg-green-100 rounded-xl flex items-center justify-center">
                        <svg class="w-7 h-7 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-slate-900">{{ __('messages.additive_manufacturing') }}</h3>
                        <p class="text-slate-500">{{ __('messages.additive_desc') }}</p>
                    </div>
                </div>
                <div class="aspect-video rounded-xl overflow-hidden">
                    <img src="{{ asset('images/services/3d-printing.jpg') }}" alt="3D Printing" class="w-full h-full object-cover" onerror="this.src='https://images.unsplash.com/photo-1581092160607-ee22621dd758?w=600'">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Materials Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <span class="text-primary-600 font-semibold text-sm uppercase tracking-wider">{{ __('messages.materials') }}</span>
            <h2 class="text-3xl md:text-4xl font-bold text-slate-900 mt-2 mb-4">
                {{ __('messages.materials_we_work_with') }}
            </h2>
            <p class="text-lg text-slate-600">{{ __('messages.material_selection_desc') }}</p>
        </div>
        
        <div class="grid lg:grid-cols-2 gap-8">
            <!-- Metals -->
            <div class="bg-gradient-to-br from-slate-800 to-slate-900 rounded-2xl p-8 text-white">
                <h3 class="text-2xl font-bold mb-6">{{ __('messages.metals') }}</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach(['titanium', 'tungsten', 'stainless_steel', 'aluminum', 'brass', 'bronze', 'copper', 'carbon_steel', 'alloy_steel', 'nickel_200', 'kovar', 'monel'] as $metal)
                        <span class="px-3 py-1 bg-white/10 rounded-full text-sm">{{ __('messages.' . $metal) }}</span>
                    @endforeach
                </div>
            </div>
            
            <!-- Plastics -->
            <div class="bg-gradient-to-br from-primary-600 to-primary-700 rounded-2xl p-8 text-white">
                <h3 class="text-2xl font-bold mb-6">{{ __('messages.plastics') }}</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach(['pom_delrin', 'abs', 'nylon', 'peek', 'ptfe', 'pvc', 'pmma', 'pei', 'hdpe', 'polypropylene'] as $plastic)
                        <span class="px-3 py-1 bg-white/10 rounded-full text-sm">{{ __('messages.' . $plastic) }}</span>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-700">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">{{ __('messages.ready_to_start') }}</h2>
        <p class="text-xl text-primary-100 mb-8 max-w-2xl mx-auto">{{ __('messages.cta_description') }}</p>
        <a href="{{ route('quote') }}" class="inline-flex items-center justify-center px-8 py-3 bg-white text-primary-600 font-semibold rounded-lg hover:bg-primary-50 transition-colors">
            {{ __('messages.request_quote') }}
        </a>
    </div>
</section>
@endsection
