@extends('frontend.layouts.app')

@section('title', ($service->getTranslation('title', app()->getLocale()) ?? __('messages.services')) . ' - ' . config('app.name'))
@section('meta_description', $service->getTranslation('excerpt', app()->getLocale()) ?? '')

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[45vh] flex items-center justify-center bg-gradient-to-br from-slate-900 via-slate-800 to-primary-900 overflow-hidden">
    <div class="absolute inset-0 opacity-20">
        @if($service->featured_image)
            <img src="{{ $service->featured_image }}" alt="" class="w-full h-full object-cover">
        @endif
    </div>
    <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/80 to-slate-900/60"></div>
    
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="max-w-4xl mx-auto text-center">
            <nav class="mb-6">
                <ol class="flex items-center justify-center gap-2 text-sm text-slate-400">
                    <li><a href="{{ route('home') }}" class="hover:text-white">{{ __('messages.home') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li><a href="{{ route('services.index') }}" class="hover:text-white">{{ __('messages.services') }}</a></li>
                    <li><span class="mx-2">/</span></li>
                    <li class="text-primary-400">{{ $service->getTranslation('title', app()->getLocale()) }}</li>
                </ol>
            </nav>
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6">
                {{ $service->getTranslation('title', app()->getLocale()) }}
            </h1>
            @if($service->getTranslation('excerpt', app()->getLocale()))
                <p class="text-xl text-slate-300 leading-relaxed">
                    {{ $service->getTranslation('excerpt', app()->getLocale()) }}
                </p>
            @endif
        </div>
    </div>
    
    <div class="absolute bottom-0 left-0 right-0">
        <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0 100V50C240 16.67 480 0 720 0C960 0 1200 16.67 1440 50V100H0Z" fill="white"/>
        </svg>
    </div>
</section>

<!-- Content -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            @if($service->getTranslation('content', app()->getLocale()))
                <div class="prose prose-lg max-w-none prose-headings:text-slate-900 prose-p:text-slate-600 prose-a:text-primary-600">
                    {!! $service->getTranslation('content', app()->getLocale()) !!}
                </div>
            @endif
            
            <!-- Service Sections -->
            @if($service->sections && $service->sections->count() > 0)
                <div class="mt-12 space-y-12">
                    @foreach($service->sections as $section)
                        <div class="border-t border-slate-200 pt-12">
                            <h2 class="text-2xl font-bold text-slate-900 mb-4">
                                {{ $section->getTranslation('title', app()->getLocale()) }}
                            </h2>
                            <div class="prose prose-lg max-w-none prose-p:text-slate-600">
                                {!! $section->getTranslation('content', app()->getLocale()) !!}
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
            
            <!-- FAQs -->
            @if($service->faqs && $service->faqs->count() > 0)
                <div class="mt-16 border-t border-slate-200 pt-12">
                    <h2 class="text-2xl font-bold text-slate-900 mb-8">
                        {{ app()->getLocale() === 'ar' ? 'الأسئلة الشائعة' : 'Frequently Asked Questions' }}
                    </h2>
                    <div class="space-y-4">
                        @foreach($service->faqs as $faq)
                            <div class="bg-slate-50 rounded-xl overflow-hidden" x-data="{ open: false }">
                                <button @click="open = !open" class="w-full flex items-center justify-between p-6 text-{{ app()->getLocale() === 'ar' ? 'right' : 'left' }}">
                                    <span class="font-semibold text-slate-900">{{ $faq->getTranslation('question', app()->getLocale()) }}</span>
                                    <svg class="w-5 h-5 text-slate-500 transform transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                    </svg>
                                </button>
                                <div x-show="open" x-collapse class="px-6 pb-6">
                                    <p class="text-slate-600">{{ $faq->getTranslation('answer', app()->getLocale()) }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</section>

<!-- Related Services -->
@if(isset($relatedServices) && $relatedServices->count() > 0)
    <section class="py-20 bg-slate-50">
        <div class="container mx-auto px-4">
            <h2 class="text-2xl font-bold text-slate-900 mb-8 text-center">
                {{ app()->getLocale() === 'ar' ? 'خدمات أخرى' : 'Other Services' }}
            </h2>
            <div class="grid md:grid-cols-3 gap-8 max-w-4xl mx-auto">
                @foreach($relatedServices as $related)
                    <a href="{{ route('services.show', $related->slug) }}" class="group bg-white rounded-xl p-6 shadow-sm hover:shadow-lg transition-shadow">
                        <h3 class="text-lg font-bold text-slate-900 mb-2 group-hover:text-primary-600 transition-colors">
                            {{ $related->getTranslation('title', app()->getLocale()) }}
                        </h3>
                        <p class="text-slate-600 text-sm line-clamp-2">
                            {{ $related->getTranslation('excerpt', app()->getLocale()) }}
                        </p>
                    </a>
                @endforeach
            </div>
        </div>
    </section>
@endif

<!-- CTA Section -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-700">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">{{ __('messages.ready_to_start') }}</h2>
        <p class="text-xl text-primary-100 mb-8 max-w-2xl mx-auto">{{ __('messages.cta_description') }}</p>
        <a href="{{ route('quote') }}" class="inline-flex items-center justify-center px-8 py-3 bg-white text-primary-600 font-semibold rounded-lg hover:bg-primary-50 transition-colors">
            {{ __('messages.request_quote') }}
        </a>
    </div>
</section>
@endsection

@push('scripts')
<script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
@endpush
