<footer class="bg-slate-900 text-white">
    <!-- Main Footer -->
    <div class="container mx-auto px-4 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
            <!-- Company Info -->
            <div class="lg:col-span-1">
                <div class="flex items-center gap-3 mb-6">
                    <img src="{{ asset('images/logo-white.png') }}" alt="AISCo Logo" class="h-10 w-auto" onerror="this.style.display='none'">
                    <div>
                        <span class="text-lg font-bold">{{ __('messages.company_name') }}</span>
                        <span class="block text-xs text-primary-400 uppercase tracking-wider">{{ __('messages.precision_cnc_factory') }}</span>
                    </div>
                </div>
                <p class="text-slate-400 text-sm leading-relaxed mb-6">
                    {{ __('messages.tagline') }}
                </p>
                <div class="flex items-center gap-4">
                    <a href="#" class="w-10 h-10 bg-slate-800 rounded-lg flex items-center justify-center hover:bg-primary-600 transition-colors" aria-label="LinkedIn">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/></svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-slate-800 rounded-lg flex items-center justify-center hover:bg-primary-600 transition-colors" aria-label="Twitter">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                    </a>
                    <a href="https://wa.me/966505622994" class="w-10 h-10 bg-slate-800 rounded-lg flex items-center justify-center hover:bg-green-600 transition-colors" aria-label="WhatsApp">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/></svg>
                    </a>
                </div>
            </div>

            <!-- Quick Links -->
            <div>
                <h3 class="text-lg font-semibold mb-6">{{ __('messages.quick_links') }}</h3>
                <ul class="space-y-3">
                    <li><a href="{{ route('about') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.about_us') }}</a></li>
                    <li><a href="{{ route('services.index') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.services') }}</a></li>
                    <li><a href="{{ route('industries.index') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.industries') }}</a></li>
                    <li><a href="{{ route('projects.index') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.projects') }}</a></li>
                    <li><a href="{{ route('careers.index') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.careers') }}</a></li>
                    <li><a href="{{ route('contact') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.contact_us') }}</a></li>
                </ul>
            </div>

            <!-- Services -->
            <div>
                <h3 class="text-lg font-semibold mb-6">{{ __('messages.our_services_footer') }}</h3>
                <ul class="space-y-3">
                    <li><a href="{{ route('services.show', 'cnc-manufacturing') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.cnc_manufacturing') }}</a></li>
                    <li><a href="{{ route('services.show', 'pattern-making') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.pattern_making') }}</a></li>
                    <li><a href="{{ route('services.show', 'reverse-engineering') }}" class="text-slate-400 hover:text-primary-400 transition-colors text-sm">{{ __('messages.reverse_engineering') }}</a></li>
                </ul>
            </div>

            <!-- Contact Info -->
            <div>
                <h3 class="text-lg font-semibold mb-6">{{ __('messages.contact_info_footer') }}</h3>
                <ul class="space-y-4">
                    <li class="flex items-start gap-3">
                        <svg class="w-5 h-5 text-primary-400 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                        <span class="text-slate-400 text-sm">{{ app()->getLocale() === 'ar' ? 'جدة، المملكة العربية السعودية' : 'Jeddah, Kingdom of Saudi Arabia' }}</span>
                    </li>
                    <li>
                        <a href="tel:+966505622994" class="flex items-center gap-3 text-slate-400 hover:text-primary-400 transition-colors">
                            <svg class="w-5 h-5 text-primary-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                            </svg>
                            <span class="text-sm">+966 505 622 994</span>
                        </a>
                    </li>
                    <li>
                        <a href="mailto:info@aiscksa.com" class="flex items-center gap-3 text-slate-400 hover:text-primary-400 transition-colors">
                            <svg class="w-5 h-5 text-primary-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            <span class="text-sm">info@aiscksa.com</span>
                        </a>
                    </li>
                    <li class="flex items-start gap-3">
                        <svg class="w-5 h-5 text-primary-400 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span class="text-slate-400 text-sm">{{ __('messages.working_hours_value') }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Bottom Bar -->
    <div class="border-t border-slate-800">
        <div class="container mx-auto px-4 py-6">
            <div class="flex flex-col md:flex-row items-center justify-between gap-4">
                <p class="text-slate-500 text-sm">
                    © {{ date('Y') }} {{ __('messages.company_full_name') }}. {{ __('messages.all_rights_reserved') }}
                </p>
                <div class="flex items-center gap-6 text-sm">
                    <a href="#" class="text-slate-500 hover:text-primary-400 transition-colors">{{ __('messages.privacy_policy') }}</a>
                    <a href="#" class="text-slate-500 hover:text-primary-400 transition-colors">{{ __('messages.terms_conditions') }}</a>
                </div>
            </div>
        </div>
    </div>
</footer>
