<header class="sticky top-0 z-50 bg-white/95 backdrop-blur-md shadow-sm border-b border-slate-100">
    <!-- Top Bar -->
    <div class="hidden lg:block bg-slate-900 text-white">
        <div class="container mx-auto px-4">
            <div class="flex items-center justify-between h-10 text-sm">
                <div class="flex items-center gap-6">
                    <a href="tel:+966505622994" class="flex items-center gap-2 hover:text-primary-400 transition-colors">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                        </svg>
                        <span>+966 505 622 994</span>
                    </a>
                    <a href="mailto:info@aiscksa.com" class="flex items-center gap-2 hover:text-primary-400 transition-colors">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                        <span>info@aiscksa.com</span>
                    </a>
                </div>
                <div class="flex items-center gap-4">
                    <!-- Language Switcher -->
                    <div class="flex items-center gap-2">
                        <a href="{{ route('language.switch', 'en') }}" 
                           class="px-2 py-1 rounded {{ app()->getLocale() === 'en' ? 'bg-primary-600' : 'hover:bg-slate-700' }} transition-colors">
                            EN
                        </a>
                        <a href="{{ route('language.switch', 'ar') }}" 
                           class="px-2 py-1 rounded {{ app()->getLocale() === 'ar' ? 'bg-primary-600' : 'hover:bg-slate-700' }} transition-colors">
                            عربي
                        </a>
                    </div>
                    <!-- Social Links -->
                    <div class="flex items-center gap-3">
                        <a href="#" class="hover:text-primary-400 transition-colors" aria-label="LinkedIn">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24"><path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/></svg>
                        </a>
                        <a href="#" class="hover:text-primary-400 transition-colors" aria-label="Twitter">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Navigation -->
    <nav class="container mx-auto px-4">
        <div class="flex items-center justify-between h-20">
            <!-- Logo -->
            <a href="{{ route('home') }}" class="flex items-center gap-3">
                <img src="{{ asset('images/logo.png') }}" alt="AISCo Logo" class="h-12 w-auto" onerror="this.style.display='none'">
                <div class="flex flex-col">
                    <span class="text-lg font-bold text-slate-900 tracking-tight">Advanced Industrial Services Co</span>
                    <span class="text-xs text-primary-600 font-medium uppercase tracking-wider">Precision CNC Factory</span>
                </div>
            </a>

            <!-- Desktop Navigation -->
            <div class="hidden lg:flex items-center gap-1">
                <a href="{{ route('home') }}" class="nav-link {{ request()->routeIs('home') ? 'nav-link-active' : '' }}">
                    {{ __('messages.home') }}
                </a>
                <a href="{{ route('about') }}" class="nav-link {{ request()->routeIs('about') ? 'nav-link-active' : '' }}">
                    {{ __('messages.about') }}
                </a>
                <div class="relative group">
                    <a href="{{ route('services.index') }}" class="nav-link {{ request()->routeIs('services.*') ? 'nav-link-active' : '' }} flex items-center gap-1">
                        {{ __('messages.services') }}
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                        </svg>
                    </a>
                    <div class="absolute top-full {{ app()->getLocale() === 'ar' ? 'right-0' : 'left-0' }} pt-2 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200">
                        <div class="bg-white rounded-xl shadow-xl border border-slate-100 py-2 min-w-[220px]">
                            <a href="{{ route('services.show', 'cnc-manufacturing') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-primary-50 hover:text-primary-600">{{ __('messages.cnc_manufacturing') }}</a>
                            <a href="{{ route('services.show', 'pattern-making') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-primary-50 hover:text-primary-600">{{ __('messages.pattern_making') }}</a>
                            <a href="{{ route('services.show', 'reverse-engineering') }}" class="block px-4 py-2 text-sm text-slate-700 hover:bg-primary-50 hover:text-primary-600">{{ __('messages.reverse_engineering') }}</a>
                        </div>
                    </div>
                </div>
                <a href="{{ route('industries.index') }}" class="nav-link {{ request()->routeIs('industries.*') ? 'nav-link-active' : '' }}">
                    {{ __('messages.industries') }}
                </a>
                <a href="{{ route('projects.index') }}" class="nav-link {{ request()->routeIs('projects.*') ? 'nav-link-active' : '' }}">
                    {{ __('messages.projects') }}
                </a>
                <a href="{{ route('blog.index') }}" class="nav-link {{ request()->routeIs('blog.*') ? 'nav-link-active' : '' }}">
                    {{ __('messages.news') }}
                </a>
                <a href="{{ route('contact') }}" class="nav-link {{ request()->routeIs('contact') ? 'nav-link-active' : '' }}">
                    {{ __('messages.contact') }}
                </a>
            </div>

            <!-- CTA Button -->
            <div class="hidden lg:flex items-center gap-4">
                <a href="{{ route('quote') }}" class="btn-primary">
                    {{ __('messages.request_quote') }}
                </a>
            </div>

            <!-- Mobile Menu Button -->
            <button 
                id="mobile-menu-button" 
                class="lg:hidden w-10 h-10 flex items-center justify-center rounded-lg hover:bg-slate-100 transition-colors"
                aria-label="Toggle menu"
            >
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                </svg>
            </button>
        </div>
    </nav>

    <!-- Mobile Menu -->
    <div id="mobile-menu" class="lg:hidden hidden bg-white border-t border-slate-100">
        <div class="container mx-auto px-4 py-4">
            <div class="flex flex-col gap-2">
                <a href="{{ route('home') }}" class="mobile-nav-link">{{ __('messages.home') }}</a>
                <a href="{{ route('about') }}" class="mobile-nav-link">{{ __('messages.about') }}</a>
                <a href="{{ route('services.index') }}" class="mobile-nav-link">{{ __('messages.services') }}</a>
                <a href="{{ route('industries.index') }}" class="mobile-nav-link">{{ __('messages.industries') }}</a>
                <a href="{{ route('projects.index') }}" class="mobile-nav-link">{{ __('messages.projects') }}</a>
                <a href="{{ route('blog.index') }}" class="mobile-nav-link">{{ __('messages.news') }}</a>
                <a href="{{ route('contact') }}" class="mobile-nav-link">{{ __('messages.contact') }}</a>
                
                <!-- Mobile Language Switcher -->
                <div class="flex items-center gap-2 px-4 py-3">
                    <span class="text-sm text-slate-500">{{ app()->getLocale() === 'ar' ? 'اللغة:' : 'Language:' }}</span>
                    <a href="{{ route('language.switch', 'en') }}" 
                       class="px-3 py-1 rounded text-sm {{ app()->getLocale() === 'en' ? 'bg-primary-600 text-white' : 'bg-slate-100 text-slate-700' }}">
                        EN
                    </a>
                    <a href="{{ route('language.switch', 'ar') }}" 
                       class="px-3 py-1 rounded text-sm {{ app()->getLocale() === 'ar' ? 'bg-primary-600 text-white' : 'bg-slate-100 text-slate-700' }}">
                        عربي
                    </a>
                </div>
                
                <a href="{{ route('quote') }}" class="btn-primary w-full text-center mt-4">{{ __('messages.request_quote') }}</a>
            </div>
        </div>
    </div>
</header>

<script>
    const mobileMenuBtn = document.getElementById('mobile-menu-button');
    const mobileMenu = document.getElementById('mobile-menu');
    mobileMenuBtn.addEventListener('click', () => {
        mobileMenu.classList.toggle('hidden');
    });
</script>
